/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.exception;

import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.locale.ResourceBundleUtils;
import java.util.Locale;

public final class LocalizedExceptionUtils {
    private LocalizedExceptionUtils() {
    }

    public static void throwException(Class<? extends RuntimeException> exceptionType, String message, Object ... args) {
        throw ClassUtils.newInstance(exceptionType, LocalizedExceptionUtils.getMessage(exceptionType, message, args, null));
    }

    public static void throwException(Class<? extends RuntimeException> exceptionType, Locale locale, String message, Object ... args) {
        throw ClassUtils.newInstance(exceptionType, LocalizedExceptionUtils.getMessage(exceptionType, message, args, locale));
    }

    public static void throwException(Class<? extends RuntimeException> exceptionType, Throwable cause, String message, Object ... args) {
        throw ClassUtils.newInstance(exceptionType, LocalizedExceptionUtils.getMessage(exceptionType, message, args, null), cause);
    }

    public static void throwException(Class<? extends RuntimeException> exceptionType, Throwable cause, Locale locale, String message, Object ... args) {
        throw ClassUtils.newInstance(exceptionType, LocalizedExceptionUtils.getMessage(exceptionType, message, args, locale), cause);
    }

    private static String getMessage(Class<? extends RuntimeException> exceptionType, String message, Object[] args, Locale locale) {
        AssertIllegalArgument.isNotNull(exceptionType, "Class<? extends RuntimeException> exceptionType");
        String msg = null;
        int keyIndex = message.indexOf(35);
        char firstChar = message.charAt(0);
        msg = firstChar == '@' && keyIndex != -1 ? ResourceBundleUtils.getString(message, args, locale) : (firstChar == '#' ? ResourceBundleUtils.getString(exceptionType, message.substring(1), args, locale) : message);
        return msg;
    }
}

