/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.cache;

import java.util.LinkedHashSet;
import java.util.Set;
import javax.cache.event.CacheEntryCreatedListener;
import javax.cache.event.CacheEntryEvent;
import javax.cache.event.CacheEntryExpiredListener;
import javax.cache.event.CacheEntryListener;
import javax.cache.event.CacheEntryRemovedListener;
import javax.cache.event.CacheEntryUpdatedListener;

public class MulitiCacheEntryListener<K, V>
implements CacheEntryCreatedListener<K, V>,
CacheEntryUpdatedListener<K, V>,
CacheEntryRemovedListener<K, V>,
CacheEntryExpiredListener<K, V> {
    private Set<CacheEntryListener<K, V>> listeners = new LinkedHashSet<CacheEntryListener<K, V>>(0);

    public MulitiCacheEntryListener<K, V> addListener(CacheEntryListener<K, V> listener) {
        this.listeners.add(listener);
        return this;
    }

    public MulitiCacheEntryListener<K, V> addListener(CacheEntryListener<K, V> ... listeners) {
        for (CacheEntryListener<K, V> listener : listeners) {
            this.addListener(listener);
        }
        return this;
    }

    public void onCreated(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) {
        for (CacheEntryListener<K, V> listener : this.listeners) {
            if (!(listener instanceof CacheEntryCreatedListener)) continue;
            ((CacheEntryCreatedListener)listener).onCreated(events);
        }
    }

    public void onUpdated(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) {
        for (CacheEntryListener<K, V> listener : this.listeners) {
            if (!(listener instanceof CacheEntryUpdatedListener)) continue;
            ((CacheEntryUpdatedListener)listener).onUpdated(events);
        }
    }

    public void onRemoved(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) {
        for (CacheEntryListener<K, V> listener : this.listeners) {
            if (!(listener instanceof CacheEntryRemovedListener)) continue;
            ((CacheEntryRemovedListener)listener).onRemoved(events);
        }
    }

    public void onExpired(Iterable<CacheEntryEvent<? extends K, ? extends V>> events) {
        for (CacheEntryListener<K, V> listener : this.listeners) {
            if (!(listener instanceof CacheEntryExpiredListener)) continue;
            ((CacheEntryExpiredListener)listener).onExpired(events);
        }
    }
}

