/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.cache;

import cn.featherfly.common.cache.CacheConfig;
import cn.featherfly.common.cache.ExpiryPolicys;
import java.net.URI;
import java.util.Map;
import java.util.Properties;
import javax.cache.Cache;
import javax.cache.Caching;
import javax.cache.configuration.Configuration;
import javax.cache.configuration.Factory;
import javax.cache.configuration.FactoryBuilder;
import javax.cache.configuration.MutableConfiguration;
import javax.cache.expiry.AccessedExpiryPolicy;
import javax.cache.expiry.CreatedExpiryPolicy;
import javax.cache.expiry.Duration;
import javax.cache.expiry.EternalExpiryPolicy;
import javax.cache.expiry.ExpiryPolicy;
import javax.cache.expiry.ModifiedExpiryPolicy;
import javax.cache.expiry.TouchedExpiryPolicy;
import javax.cache.spi.CachingProvider;

public class CacheManager
implements javax.cache.CacheManager {
    private javax.cache.CacheManager cacheManager;

    public CacheManager(Map<String, CacheConfig> cacheConfigs) {
        CachingProvider cachingProvider = Caching.getCachingProvider();
        this.cacheManager = cachingProvider.getCacheManager();
        this.loadCaches(cacheConfigs);
    }

    private void loadCaches(Map<String, CacheConfig> cacheConfigs) {
        for (Map.Entry<String, CacheConfig> entry : cacheConfigs.entrySet()) {
            MutableConfiguration configuration = new MutableConfiguration();
            CacheConfig config = entry.getValue();
            Duration expriy = new Duration(config.getTimeUnit(), config.getExpiry());
            configuration.setExpiryPolicyFactory(CacheManager.factoryOf(expriy, config.getExpiryPolicy()));
            this.cacheManager.createCache(entry.getKey(), (Configuration)configuration);
        }
    }

    private static Factory<ExpiryPolicy> factoryOf(Duration expiry, ExpiryPolicys policy) {
        switch (policy) {
            case ETERNAL: {
                return new FactoryBuilder.SingletonFactory((Object)new EternalExpiryPolicy());
            }
            case CREATED: {
                return new FactoryBuilder.SingletonFactory((Object)new CreatedExpiryPolicy(expiry));
            }
            case ACCESSED: {
                return new FactoryBuilder.SingletonFactory((Object)new AccessedExpiryPolicy(expiry));
            }
            case MODIFIED: {
                return new FactoryBuilder.SingletonFactory((Object)new ModifiedExpiryPolicy(expiry));
            }
            case TOUCHED: {
                return new FactoryBuilder.SingletonFactory((Object)new TouchedExpiryPolicy(expiry));
            }
        }
        return new FactoryBuilder.SingletonFactory((Object)new EternalExpiryPolicy());
    }

    public <K, V> Cache<K, V> getCache(String cacheName) {
        return this.cacheManager.getCache(cacheName);
    }

    public <K, V> Cache<K, V> getCache(String cacheName, Class<K> keyType, Class<V> valueType) {
        return this.cacheManager.getCache(cacheName, keyType, valueType);
    }

    public CachingProvider getCachingProvider() {
        return this.cacheManager.getCachingProvider();
    }

    public URI getURI() {
        return this.cacheManager.getURI();
    }

    public ClassLoader getClassLoader() {
        return this.cacheManager.getClassLoader();
    }

    public Properties getProperties() {
        return this.cacheManager.getProperties();
    }

    public <K, V, C extends Configuration<K, V>> Cache<K, V> createCache(String cacheName, C configuration) throws IllegalArgumentException {
        return this.cacheManager.createCache(cacheName, configuration);
    }

    public Iterable<String> getCacheNames() {
        return this.cacheManager.getCacheNames();
    }

    public void destroyCache(String cacheName) {
        this.cacheManager.destroyCache(cacheName);
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.cacheManager.enableManagement(cacheName, enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.cacheManager.enableStatistics(cacheName, enabled);
    }

    public void close() {
        this.cacheManager.close();
    }

    public boolean isClosed() {
        return this.cacheManager.isClosed();
    }

    public <T> T unwrap(Class<T> clazz) {
        return (T)this.cacheManager.unwrap(clazz);
    }
}

