/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.bean;

import cn.featherfly.common.asm.Asm;
import cn.featherfly.common.asm.AsmException;
import cn.featherfly.common.bean.AbstractProperty;
import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.Property;
import cn.featherfly.common.bean.PropertyAccessException;
import cn.featherfly.common.bean.PropertyAccessor;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.BytesClassLoader;
import cn.featherfly.common.lang.ClassLoaderUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.ReloadableClassloader;
import cn.featherfly.common.lang.WordUtils;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.List;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class AsmPropertyFactory
extends ReloadableClassloader
implements Opcodes {
    public static final String CLASS_NAME_SUFFIX = "Property";
    private static final String GET_METHOD_NAME = "get";
    private static final String SET_METHOD_NAME = "set";
    private static final String IS_READABLE_METHOD_NAME = "isReadable";
    private static final String IS_WRITABLE_METHOD_NAME = "isWritable";
    private final BytesClassLoader bytesClassLoader;

    public AsmPropertyFactory(BytesClassLoader bytesClassLoader) {
        this.bytesClassLoader = bytesClassLoader;
    }

    public <T, V> Property<T, V> newInstance(Class<Property<T, V>> propertyType, PropertyAccessor<T> propertyVisitor) {
        return (Property)ClassUtils.newInstance(propertyType, (Object[])new Object[]{propertyVisitor});
    }

    public <T, V> Class<Property<T, V>> create(String propertyVisitorName, Class<T> instanceType, Class<V> propertyType, String propertyName, int propertyIndex, ClassLoader classLoader) {
        try {
            classLoader = this.prepare(classLoader);
            String createdClassName = this.createInnerClassName(propertyVisitorName, propertyName);
            String createdClassNameBcf = Asm.getName(createdClassName);
            String instanceClassNameBcf = Asm.getName(instanceType);
            String propertyClassNameBcf = Asm.getName(propertyType);
            ClassWriter cw = new ClassWriter(1);
            ClassNode classNode = new ClassNode();
            classNode.version = 52;
            classNode.access = 1;
            classNode.name = createdClassNameBcf;
            classNode.superName = Type.getInternalName(AbstractProperty.class);
            SignatureWriter signature = new SignatureWriter();
            SignatureVisitor instantiatorVisitor = signature.visitSuperclass();
            instantiatorVisitor.visitClassType(classNode.superName);
            SignatureVisitor instanceTypeVisitor = instantiatorVisitor.visitTypeArgument('=');
            instanceTypeVisitor.visitClassType(Type.getInternalName(instanceType));
            instanceTypeVisitor.visitEnd();
            SignatureVisitor propertyTypeVisitor = instantiatorVisitor.visitTypeArgument('=');
            propertyTypeVisitor.visitClassType(Type.getInternalName(propertyType));
            propertyTypeVisitor.visitEnd();
            instantiatorVisitor.visitEnd();
            classNode.signature = signature.toString();
            classNode.visitInnerClass(createdClassNameBcf, instanceClassNameBcf, this.createClassName(propertyName), 1);
            classNode.methods.add(this.constract(instanceType, propertyType, propertyName, propertyIndex));
            BeanProperty beanProperty = (BeanProperty)BeanDescriptor.getBeanDescriptor(instanceType).getProperty(propertyName);
            classNode.methods.addAll(this.get(createdClassNameBcf, instanceType, propertyClassNameBcf, beanProperty));
            classNode.methods.addAll(this.set(createdClassNameBcf, instanceType, propertyClassNameBcf, beanProperty));
            classNode.methods.add(this.isReadable(beanProperty.isReadable()));
            classNode.methods.add(this.isWritable(beanProperty.isWritable()));
            classNode.accept((ClassVisitor)cw);
            byte[] code = cw.toByteArray();
            return ClassLoaderUtils.defineClass((ClassLoader)classLoader, (String)createdClassName, (byte[])code, (ProtectionDomain)instanceType.getProtectionDomain(), () -> this.bytesClassLoader.defineClass(createdClassName, code, instanceType.getProtectionDomain()));
        }
        catch (Exception e) {
            throw new AsmException(e);
        }
    }

    private MethodNode constract(Class<?> instaceType, Class<?> propertyType, String propertyName, int propertyIndex) {
        SignatureWriter signature = new SignatureWriter();
        SignatureVisitor propertyVisitorTypeVisitor = signature.visitParameterType();
        propertyVisitorTypeVisitor.visitClassType(Type.getInternalName(PropertyAccessor.class));
        SignatureVisitor propertyTypeVisitor = propertyVisitorTypeVisitor.visitTypeArgument('=');
        propertyTypeVisitor.visitClassType(Type.getInternalName(instaceType));
        propertyTypeVisitor.visitEnd();
        propertyVisitorTypeVisitor.visitEnd();
        MethodNode methodNode = new MethodNode(1, "<init>", Asm.getConstructorDescriptor(PropertyAccessor.class), signature.toString(), null);
        methodNode.visitVarInsn(25, 0);
        methodNode.visitLdcInsn((Object)Type.getType(instaceType));
        if (propertyType.isPrimitive()) {
            methodNode.visitFieldInsn(178, Asm.getPrimitiveWrapperName(propertyType), "TYPE", Type.getType(Class.class).toString());
        } else {
            methodNode.visitLdcInsn((Object)Type.getType(propertyType));
        }
        methodNode.visitLdcInsn((Object)propertyName);
        switch (propertyIndex) {
            case 0: {
                methodNode.visitInsn(3);
                break;
            }
            case 1: {
                methodNode.visitInsn(4);
                break;
            }
            case 2: {
                methodNode.visitInsn(5);
                break;
            }
            case 3: {
                methodNode.visitInsn(6);
                break;
            }
            case 4: {
                methodNode.visitInsn(7);
                break;
            }
            case 5: {
                methodNode.visitInsn(8);
                break;
            }
            default: {
                methodNode.visitIntInsn(16, propertyIndex);
            }
        }
        methodNode.visitVarInsn(25, 1);
        methodNode.visitMethodInsn(183, Type.getInternalName(AbstractProperty.class), "<init>", Asm.getConstructorDescriptor(Class.class, Class.class, String.class, Integer.TYPE, PropertyAccessor.class), false);
        methodNode.visitInsn(177);
        return methodNode;
    }

    private List<MethodNode> get(String createdClassNameBcf, Class<?> instanceType, String propertyClassNameBcf, BeanProperty<?, ?> beanProperty) throws NoSuchMethodException, SecurityException {
        String instanceClassNameBcf = Type.getInternalName(instanceType);
        boolean primitive = Asm.isPrimitive(propertyClassNameBcf);
        String prefix = "boolean".equals(propertyClassNameBcf) ? "is" : GET_METHOD_NAME;
        String warrperPropertyClassNameBcf = primitive ? Asm.getPrimitiveWrapperName(propertyClassNameBcf) : propertyClassNameBcf;
        MethodNode methodNode = new MethodNode(1, GET_METHOD_NAME, Type.getMethodDescriptor((Type)Type.getObjectType((String)warrperPropertyClassNameBcf), (Type[])new Type[]{Type.getObjectType((String)instanceClassNameBcf)}), null, null);
        if (beanProperty.isReadable()) {
            methodNode.visitVarInsn(25, 1);
            methodNode.visitMethodInsn(182, instanceClassNameBcf, prefix + WordUtils.upperCaseFirst((String)beanProperty.getName()), Type.getMethodDescriptor((Method)beanProperty.getGetter()), false);
            if (primitive) {
                methodNode.visitMethodInsn(184, warrperPropertyClassNameBcf, "valueOf", Asm.getPrimitiveBoxingMethodDescriptor(propertyClassNameBcf), false);
            }
            methodNode.visitInsn(176);
        } else {
            methodNode.visitVarInsn(25, 0);
            methodNode.visitFieldInsn(180, createdClassNameBcf, "instanceType", Type.getDescriptor(Class.class));
            methodNode.visitVarInsn(25, 0);
            methodNode.visitFieldInsn(180, createdClassNameBcf, "name", Type.getDescriptor(String.class));
            methodNode.visitMethodInsn(184, Type.getInternalName(PropertyAccessException.class), "propertyNoGetter", Type.getMethodDescriptor((Type)Type.getType(PropertyAccessException.class), (Type[])new Type[]{Asm.getType(Class.class), Type.getType(String.class)}), false);
            methodNode.visitInsn(191);
        }
        methodNode.visitEnd();
        MethodNode methodNode2 = new MethodNode(4161, GET_METHOD_NAME, Type.getMethodDescriptor((Method)Property.class.getMethod(GET_METHOD_NAME, Object.class)), null, null);
        methodNode2.visitVarInsn(25, 0);
        methodNode2.visitVarInsn(25, 1);
        methodNode2.visitTypeInsn(192, instanceClassNameBcf);
        methodNode2.visitMethodInsn(182, createdClassNameBcf, GET_METHOD_NAME, Type.getMethodDescriptor((Type)Type.getObjectType((String)warrperPropertyClassNameBcf), (Type[])new Type[]{Type.getObjectType((String)instanceClassNameBcf)}), false);
        methodNode2.visitInsn(176);
        methodNode2.visitEnd();
        return Lang.list((Object[])new MethodNode[]{methodNode, methodNode2});
    }

    private List<MethodNode> set(String createdClassNameBcf, Class<?> instanceType, String propertyClassNameBcf, BeanProperty<?, ?> beanProperty) throws NoSuchMethodException, SecurityException {
        String instanceClassNameBcf = Type.getInternalName(instanceType);
        boolean primitive = Asm.isPrimitive(propertyClassNameBcf);
        String warrperPropertyClassNameBcf = primitive ? Asm.getPrimitiveWrapperName(propertyClassNameBcf) : propertyClassNameBcf;
        String setMethodDescptor = Type.getMethodDescriptor((Type)Type.getType(Void.TYPE), (Type[])new Type[]{Type.getObjectType((String)instanceClassNameBcf), Type.getObjectType((String)warrperPropertyClassNameBcf)});
        MethodNode methodNode = new MethodNode(1, SET_METHOD_NAME, setMethodDescptor, null, null);
        if (beanProperty.isWritable()) {
            methodNode.visitVarInsn(25, 1);
            methodNode.visitVarInsn(25, 2);
            if (primitive) {
                methodNode.visitMethodInsn(182, warrperPropertyClassNameBcf, Asm.getPrimitiveUnboxingMethod(propertyClassNameBcf), Asm.getPrimitiveUnboxingMethodDescriptor(propertyClassNameBcf), false);
            }
            methodNode.visitMethodInsn(182, instanceClassNameBcf, SET_METHOD_NAME + WordUtils.upperCaseFirst((String)beanProperty.getName()), Type.getMethodDescriptor((Method)beanProperty.getSetter()), false);
            methodNode.visitInsn(177);
        } else {
            methodNode.visitVarInsn(25, 0);
            methodNode.visitFieldInsn(180, createdClassNameBcf, "instanceType", Type.getDescriptor(Class.class));
            methodNode.visitVarInsn(25, 0);
            methodNode.visitFieldInsn(180, createdClassNameBcf, "name", Type.getDescriptor(String.class));
            methodNode.visitMethodInsn(184, Type.getInternalName(PropertyAccessException.class), "propertyNoSetter", Type.getMethodDescriptor((Type)Type.getType(PropertyAccessException.class), (Type[])new Type[]{Asm.getType(Class.class), Type.getType(String.class)}), false);
            methodNode.visitInsn(191);
        }
        methodNode.visitEnd();
        MethodNode methodNode2 = new MethodNode(4161, SET_METHOD_NAME, Type.getMethodDescriptor((Method)Property.class.getMethod(SET_METHOD_NAME, Object.class, Object.class)), null, null);
        methodNode2.visitVarInsn(25, 0);
        methodNode2.visitVarInsn(25, 1);
        methodNode2.visitTypeInsn(192, instanceClassNameBcf);
        methodNode2.visitVarInsn(25, 2);
        methodNode2.visitTypeInsn(192, warrperPropertyClassNameBcf);
        methodNode2.visitMethodInsn(182, createdClassNameBcf, SET_METHOD_NAME, setMethodDescptor, false);
        methodNode2.visitInsn(177);
        methodNode2.visitEnd();
        return Lang.list((Object[])new MethodNode[]{methodNode, methodNode2});
    }

    private MethodNode isReadable(boolean readable) throws NoSuchMethodException, SecurityException {
        MethodNode methodNode = new MethodNode(1, IS_READABLE_METHOD_NAME, Type.getMethodDescriptor((Method)Property.class.getMethod(IS_READABLE_METHOD_NAME, ArrayUtils.EMPTY_CLASS_ARRAY)), null, null);
        if (readable) {
            methodNode.visitInsn(4);
        } else {
            methodNode.visitInsn(3);
        }
        methodNode.visitInsn(172);
        methodNode.visitEnd();
        return methodNode;
    }

    private MethodNode isWritable(boolean writable) throws NoSuchMethodException, SecurityException {
        MethodNode methodNode = new MethodNode(1, IS_WRITABLE_METHOD_NAME, Type.getMethodDescriptor((Method)Property.class.getMethod(IS_WRITABLE_METHOD_NAME, ArrayUtils.EMPTY_CLASS_ARRAY)), null, null);
        if (writable) {
            methodNode.visitInsn(4);
        } else {
            methodNode.visitInsn(3);
        }
        methodNode.visitInsn(172);
        methodNode.visitEnd();
        return methodNode;
    }

    private String createClassName(String propertyName) {
        return WordUtils.upperCaseFirst((String)propertyName) + CLASS_NAME_SUFFIX;
    }

    private String createInnerClassName(String outerClassName, String propertyName) {
        return outerClassName + this.createClassName(propertyName);
    }

    protected void doClassLoaderReload() {
    }
}

