/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.bean;

import cn.featherfly.common.asm.Asm;
import cn.featherfly.common.asm.AsmException;
import cn.featherfly.common.bean.AbstractProperty;
import cn.featherfly.common.bean.AbstractPropertyAccessor;
import cn.featherfly.common.bean.AsmInstantiatorFactory;
import cn.featherfly.common.bean.AsmPropertyFactory;
import cn.featherfly.common.bean.BeanDescriptor;
import cn.featherfly.common.bean.BeanProperty;
import cn.featherfly.common.bean.NoSuchPropertyException;
import cn.featherfly.common.bean.Property;
import cn.featherfly.common.bean.PropertyAccessor;
import cn.featherfly.common.bean.PropertyAccessorFactory;
import cn.featherfly.common.bean.PropertyAccessorManagerImpl;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.BytesClassLoader;
import cn.featherfly.common.lang.ClassLoaderUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.ReloadableClassloader;
import cn.featherfly.common.lang.WordUtils;
import cn.featherfly.common.policy.AllowDenyListPolicy;
import cn.featherfly.common.policy.AllowPolicy;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.UnaryOperator;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Label;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodNode;

public class AsmPropertyAccessorFactory
extends ReloadableClassloader
implements PropertyAccessorFactory,
Opcodes {
    private final PropertyAccessorManagerImpl manager;
    public static final String CLASS_NAME_SUFFIX = "PropertyVisitorCreateByFeatherfly";
    private static final String PROPERTY_MAP = "propertyMap";
    private static final String MAP_NAME = org.objectweb.asm.Type.getInternalName(LinkedHashMap.class);
    private static final String MAP_DESCRIPTOR = org.objectweb.asm.Type.getDescriptor(LinkedHashMap.class);
    private static final String GET = "get";
    private static final String GET_DESCRIPTOR = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Object.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(Object.class)});
    private static final String SET = "set";
    private static final String SET_DESCRIPTOR = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Void.TYPE), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(Object.class), org.objectweb.asm.Type.getType(Object.class)});
    private static final String MAP_PUT_NAME = "put";
    private static final String MAP_PUT_DESCRIPTOR = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Object.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(Object.class), org.objectweb.asm.Type.getType(Object.class)});
    private static final String GET_PROPERTY_METHOD = "getProperty";
    private static final String GET_PROPERTY_DESCRIPTOR_BYNAME = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Property.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(String.class)});
    private static final String SET_PROPERTY_DESCRIPTOR_BY_NAME = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Void.TYPE), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(Object.class), org.objectweb.asm.Type.getType(String.class), org.objectweb.asm.Type.getType(Object.class)});
    private static final String SET_PROPERTY_DESCRIPTOR_BY_INDEX = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Void.TYPE), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(Object.class), org.objectweb.asm.Type.getType(Integer.TYPE), org.objectweb.asm.Type.getType(Object.class)});
    private static final String GET_PROPERTY_VALUE_METHOD = "getPropertyValue";
    private static final String SET_PROPERTY_VALUE_METHOD = "setPropertyValue";
    private final BytesClassLoader bytesClassLoader;
    private final AsmPropertyFactory propertyFactory;
    private final AllowPolicy<Type> propertyVisitorCascadeCreatePolicy;

    private static AllowDenyListPolicy<Type> defaultPolicy() {
        return new AllowDenyListPolicy(AllowDenyListPolicy.Strategy.DENY_ONLY).addDeny(type -> {
            if (type.getTypeName().startsWith("java")) {
                return true;
            }
            if (type instanceof Class) {
                Class c = (Class)type;
                return c.isPrimitive() || c.isInterface() || c.isAnnotation() || c.isArray() || c.isEnum();
            }
            return false;
        });
    }

    public AsmPropertyAccessorFactory(ClassLoader classLoader) {
        this(classLoader, (AllowPolicy<Type>)AsmPropertyAccessorFactory.defaultPolicy());
    }

    public AsmPropertyAccessorFactory(ClassLoader classLoader, UnaryOperator<AllowDenyListPolicy<Type>> unary) {
        this(classLoader, (AllowPolicy<Type>)((AllowPolicy)unary.apply(AsmPropertyAccessorFactory.defaultPolicy())));
    }

    public AsmPropertyAccessorFactory(ClassLoader classLoader, AllowPolicy<Type> propertyVisitorCascadeCreatePolicy) {
        this.bytesClassLoader = new BytesClassLoader(classLoader);
        this.propertyFactory = new AsmPropertyFactory(this.bytesClassLoader);
        this.propertyVisitorCascadeCreatePolicy = propertyVisitorCascadeCreatePolicy;
        this.manager = new PropertyAccessorManagerImpl();
    }

    public <T> PropertyAccessor<T> create(Class<T> type, ClassLoader classLoader) {
        PropertyAccessor propertyAccessor = this.manager.getPropertyAccessor(type);
        if (propertyAccessor != null) {
            return propertyAccessor;
        }
        try {
            Class<PropertyAccessor<T>> newType = this.create0(type, classLoader);
            propertyAccessor = (PropertyAccessor)ClassUtils.newInstance(newType);
            this.manager.add(type, (Object)propertyAccessor);
            return propertyAccessor;
        }
        catch (Exception e) {
            throw new AsmException(e);
        }
    }

    public void createPropertyAccessorCascade(ClassLoader classLoader) {
        for (PropertyAccessor propertyAccessor : new ArrayList(this.manager.getAll())) {
            this.createPropertyAccessorRecursion(propertyAccessor, classLoader);
        }
    }

    private void createPropertyAccessorRecursion(PropertyAccessor<?> propertyAccessor, ClassLoader classLoader) {
        for (Property property : propertyAccessor.getProperties()) {
            this.createPropertyAccessorRecursion(property, classLoader);
        }
    }

    private <V> void createPropertyAccessorRecursion(Property<?, V> property, ClassLoader classLoader) {
        if (property.getPropertyAccessor() == null && this.propertyVisitorCascadeCreatePolicy.isAllow((Object)property.getType())) {
            if (this.manager.containsType(property.getType())) {
                ((AbstractProperty)property).setPropertyAccessor((PropertyAccessor)this.manager.get(property.getType()));
            } else {
                PropertyAccessor newPv = this.create(property.getType(), classLoader);
                ((AbstractProperty)property).setPropertyAccessor(newPv);
                this.createPropertyAccessorRecursion(newPv, classLoader);
            }
        }
    }

    private <T> Class<PropertyAccessor<T>> create0(Class<T> type, ClassLoader classLoader) throws NoSuchMethodException, SecurityException {
        type.getConstructor(ArrayUtils.EMPTY_CLASS_ARRAY);
        classLoader = this.prepare(classLoader);
        String instantiateType = org.objectweb.asm.Type.getInternalName(type);
        ClassWriter cw = new ClassWriter(2);
        String createdClassName = this.createClassName(type);
        String createdClassByteCodeName = Asm.getName(createdClassName);
        ClassNode classNode = new ClassNode();
        classNode.version = 52;
        classNode.access = 1;
        classNode.name = createdClassByteCodeName;
        classNode.superName = org.objectweb.asm.Type.getInternalName(AbstractPropertyAccessor.class);
        SignatureWriter signature = new SignatureWriter();
        SignatureVisitor instantiatorVisitor = signature.visitSuperclass();
        instantiatorVisitor.visitClassType(classNode.superName);
        SignatureVisitor typeVisitor = instantiatorVisitor.visitTypeArgument('=');
        typeVisitor.visitClassType(org.objectweb.asm.Type.getInternalName(type));
        typeVisitor.visitEnd();
        instantiatorVisitor.visitEnd();
        classNode.signature = signature.toString();
        String hashMapBcf = MAP_NAME;
        SignatureWriter fieldsMapSignature = new SignatureWriter();
        fieldsMapSignature.visitClassType(hashMapBcf);
        SignatureVisitor fieldsMapKey = fieldsMapSignature.visitTypeArgument('=');
        fieldsMapKey.visitClassType(org.objectweb.asm.Type.getInternalName(String.class));
        fieldsMapKey.visitEnd();
        SignatureVisitor fieldsMapValue = fieldsMapSignature.visitTypeArgument('=');
        fieldsMapValue.visitClassType(org.objectweb.asm.Type.getInternalName(Property.class));
        fieldsMapValue.visitEnd();
        fieldsMapSignature.visitEnd();
        BeanDescriptor bd = BeanDescriptor.getBeanDescriptor(type);
        int i = 0;
        ArrayList newPropertyTypes = new ArrayList();
        for (BeanProperty beanProperty : bd.getBeanProperties()) {
            Class propertyType = this.propertyFactory.create(createdClassName, type, beanProperty.getType(), beanProperty.getName(), i, classLoader);
            ++i;
            newPropertyTypes.add(propertyType);
            FieldNode fieldNode = new FieldNode(18, beanProperty.getName(), org.objectweb.asm.Type.getDescriptor(propertyType), null, null);
            classNode.fields.add(fieldNode);
        }
        classNode.fields.add(new FieldNode(18, PROPERTY_MAP, MAP_DESCRIPTOR, fieldsMapSignature.toString(), null));
        classNode.methods.add(this.constructor(classNode, newPropertyTypes));
        classNode.methods.add(AsmInstantiatorFactory.createMethodInstantiate(instantiateType));
        classNode.methods.add(AsmInstantiatorFactory.createMethodGetType(type));
        classNode.methods.add(this.methodGetPropertyByIndex(classNode, newPropertyTypes, bd));
        classNode.methods.add(this.methodGetPropertyByName(classNode, newPropertyTypes, bd));
        classNode.methods.addAll(this.methodGetPropertyValueByIndex(classNode, newPropertyTypes, bd));
        classNode.methods.addAll(this.methodGetPropertyValueByName(classNode, bd));
        classNode.methods.addAll(this.methodSetPropertyValueByName(classNode, bd));
        classNode.methods.addAll(this.methodSetPropertyValueByIndex(classNode, newPropertyTypes, bd));
        classNode.methods.add(this.methodGetProperties(classNode));
        classNode.accept((ClassVisitor)cw);
        byte[] code = cw.toByteArray();
        return ClassLoaderUtils.defineClass((ClassLoader)classLoader, (String)createdClassByteCodeName, (byte[])code, (ProtectionDomain)type.getProtectionDomain(), () -> this.bytesClassLoader.defineClass(createdClassName, code, type.getProtectionDomain()));
    }

    private MethodNode constructor(ClassNode classNode, List<Class<?>> propertyTypes) {
        MethodNode methodNode = new MethodNode(1, "<init>", Asm.getConstructorDescriptor(), null, null);
        methodNode.visitVarInsn(25, 0);
        methodNode.visitMethodInsn(183, classNode.superName, "<init>", Asm.getConstructorDescriptor(), false);
        String hashMapBcf = MAP_NAME;
        methodNode.visitVarInsn(25, 0);
        methodNode.visitTypeInsn(187, hashMapBcf);
        methodNode.visitInsn(89);
        methodNode.visitMethodInsn(183, hashMapBcf, "<init>", Asm.getConstructorDescriptor(), false);
        methodNode.visitFieldInsn(181, classNode.name, PROPERTY_MAP, MAP_DESCRIPTOR);
        int i = 0;
        for (Class<?> propertyType : propertyTypes) {
            FieldNode field = (FieldNode)classNode.fields.get(i);
            String propertyTypeBcf = org.objectweb.asm.Type.getInternalName(propertyType);
            methodNode.visitVarInsn(25, 0);
            methodNode.visitTypeInsn(187, org.objectweb.asm.Type.getInternalName(propertyType));
            methodNode.visitInsn(89);
            methodNode.visitInsn(1);
            methodNode.visitMethodInsn(183, propertyTypeBcf, "<init>", Asm.getConstructorDescriptor(PropertyAccessor.class), false);
            methodNode.visitFieldInsn(181, classNode.name, field.name, field.desc);
            methodNode.visitVarInsn(25, 0);
            methodNode.visitFieldInsn(180, classNode.name, PROPERTY_MAP, MAP_DESCRIPTOR);
            methodNode.visitLdcInsn((Object)field.name);
            methodNode.visitVarInsn(25, 0);
            methodNode.visitFieldInsn(180, classNode.name, field.name, field.desc);
            methodNode.visitMethodInsn(182, hashMapBcf, MAP_PUT_NAME, MAP_PUT_DESCRIPTOR, false);
            methodNode.visitInsn(87);
            ++i;
        }
        methodNode.visitInsn(177);
        methodNode.visitEnd();
        return methodNode;
    }

    private List<MethodNode> methodGetPropertyValueByIndex(ClassNode classNode, List<Class<?>> propertyTypes, BeanDescriptor<?> bd) throws SecurityException {
        String methodName = GET_PROPERTY_VALUE_METHOD;
        String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Object.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType((Class)bd.getType()), org.objectweb.asm.Type.getType(Integer.TYPE)});
        MethodNode methodNode = new MethodNode(1, GET_PROPERTY_VALUE_METHOD, methodDescriptor, null, null);
        methodNode.visitIntInsn(21, 2);
        Label[] labels = new Label[propertyTypes.size()];
        for (int i = 0; i < propertyTypes.size(); ++i) {
            labels[i] = new Label();
        }
        Label labelDeft = new Label();
        methodNode.visitTableSwitchInsn(0, propertyTypes.size() - 1, labelDeft, labels);
        for (int i = 0; i < propertyTypes.size(); ++i) {
            BeanProperty bp = bd.getBeanProperty(i);
            methodNode.visitLabel(labels[i]);
            methodNode.visitVarInsn(25, 1);
            String prefix = bp.getType() == Boolean.TYPE ? "is" : GET;
            methodNode.visitMethodInsn(182, org.objectweb.asm.Type.getInternalName((Class)bd.getType()), prefix + WordUtils.upperCaseFirst((String)bp.getName()), org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)Asm.getType(bp.getType()), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), false);
            if (bp.getType().isPrimitive()) {
                methodNode.visitMethodInsn(184, Asm.getPrimitiveWrapperName(bp.getType().getName()), "valueOf", Asm.getPrimitiveBoxingMethodDescriptor(bp.getType().getName()), false);
            }
            methodNode.visitInsn(176);
        }
        String exceptionBcnf = org.objectweb.asm.Type.getInternalName(NoSuchPropertyException.class);
        methodNode.visitLabel(labelDeft);
        methodNode.visitTypeInsn(187, exceptionBcnf);
        methodNode.visitInsn(89);
        methodNode.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)bd.getType()));
        methodNode.visitIntInsn(21, 2);
        methodNode.visitMethodInsn(183, exceptionBcnf, "<init>", Asm.getConstructorDescriptor(Class.class, Integer.TYPE), false);
        methodNode.visitInsn(191);
        methodNode.visitEnd();
        MethodNode methodNode2 = new MethodNode(4161, GET_PROPERTY_VALUE_METHOD, org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Object.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(Object.class), org.objectweb.asm.Type.getType(Integer.TYPE)}), null, null);
        methodNode2.visitVarInsn(25, 0);
        methodNode2.visitVarInsn(25, 1);
        methodNode2.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName((Class)bd.getType()));
        methodNode2.visitIntInsn(21, 2);
        methodNode2.visitMethodInsn(182, classNode.name, GET_PROPERTY_VALUE_METHOD, methodDescriptor, false);
        methodNode2.visitInsn(176);
        methodNode2.visitEnd();
        return Lang.list((Object[])new MethodNode[]{methodNode, methodNode2});
    }

    private List<MethodNode> methodGetPropertyValueByName(ClassNode classNode, BeanDescriptor<?> bd) throws SecurityException {
        String methodName = GET_PROPERTY_VALUE_METHOD;
        String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Object.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType((Class)bd.getType()), org.objectweb.asm.Type.getType(String.class)});
        MethodNode methodNode = new MethodNode(1, GET_PROPERTY_VALUE_METHOD, methodDescriptor, null, null);
        methodNode.visitVarInsn(25, 0);
        methodNode.visitVarInsn(25, 2);
        methodNode.visitMethodInsn(182, classNode.name, GET_PROPERTY_METHOD, GET_PROPERTY_DESCRIPTOR_BYNAME, false);
        methodNode.visitVarInsn(25, 1);
        methodNode.visitMethodInsn(185, org.objectweb.asm.Type.getInternalName(Property.class), GET, GET_DESCRIPTOR, true);
        methodNode.visitInsn(176);
        methodNode.visitEnd();
        MethodNode methodNode2 = new MethodNode(4161, GET_PROPERTY_VALUE_METHOD, org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Object.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType(Object.class), org.objectweb.asm.Type.getType(String.class)}), null, null);
        methodNode2.visitVarInsn(25, 0);
        methodNode2.visitVarInsn(25, 1);
        methodNode2.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName((Class)bd.getType()));
        methodNode2.visitVarInsn(25, 2);
        methodNode2.visitMethodInsn(182, classNode.name, GET_PROPERTY_VALUE_METHOD, methodDescriptor, false);
        methodNode2.visitInsn(176);
        methodNode2.visitEnd();
        return Lang.list((Object[])new MethodNode[]{methodNode, methodNode2});
    }

    private List<MethodNode> methodSetPropertyValueByIndex(ClassNode classNode, List<Class<?>> propertyTypes, BeanDescriptor<?> bd) throws SecurityException {
        String methodName = SET_PROPERTY_VALUE_METHOD;
        String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Void.TYPE), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType((Class)bd.getType()), org.objectweb.asm.Type.getType(Integer.TYPE), org.objectweb.asm.Type.getType(Object.class)});
        MethodNode methodNode = new MethodNode(1, SET_PROPERTY_VALUE_METHOD, methodDescriptor, null, null);
        methodNode.visitIntInsn(21, 2);
        Label[] labels = new Label[propertyTypes.size()];
        for (int i = 0; i < propertyTypes.size(); ++i) {
            labels[i] = new Label();
        }
        Label labelDeft = new Label();
        methodNode.visitTableSwitchInsn(0, propertyTypes.size() - 1, labelDeft, labels);
        for (int i = 0; i < propertyTypes.size(); ++i) {
            BeanProperty bp = bd.getBeanProperty(i);
            String propertyTypeBcnf = org.objectweb.asm.Type.getInternalName((Class)bp.getType());
            methodNode.visitLabel(labels[i]);
            methodNode.visitVarInsn(25, 1);
            methodNode.visitVarInsn(25, 3);
            methodNode.visitTypeInsn(192, Asm.getPrimitiveWrapperName(propertyTypeBcnf));
            if (bp.getType().isPrimitive()) {
                methodNode.visitMethodInsn(182, Asm.getPrimitiveWrapperName(bp.getType()), Asm.getPrimitiveUnboxingMethod(bp.getType()), Asm.getPrimitiveUnboxingMethodDescriptor(bp.getType()), false);
            }
            methodNode.visitMethodInsn(182, org.objectweb.asm.Type.getInternalName((Class)bd.getType()), SET + WordUtils.upperCaseFirst((String)bp.getName()), bp.getSetter() != null ? org.objectweb.asm.Type.getMethodDescriptor((Method)bp.getSetter()) : org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Void.TYPE), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType((Class)bp.getType())}), false);
            methodNode.visitInsn(177);
        }
        String exceptionBcnf = org.objectweb.asm.Type.getInternalName(NoSuchPropertyException.class);
        methodNode.visitLabel(labelDeft);
        methodNode.visitTypeInsn(187, exceptionBcnf);
        methodNode.visitInsn(89);
        methodNode.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)bd.getType()));
        methodNode.visitIntInsn(21, 2);
        methodNode.visitMethodInsn(183, exceptionBcnf, "<init>", Asm.getConstructorDescriptor(Class.class, Integer.TYPE), false);
        methodNode.visitInsn(191);
        methodNode.visitEnd();
        MethodNode methodNode2 = new MethodNode(4161, SET_PROPERTY_VALUE_METHOD, SET_PROPERTY_DESCRIPTOR_BY_INDEX, null, null);
        methodNode2.visitVarInsn(25, 0);
        methodNode2.visitVarInsn(25, 1);
        methodNode2.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName((Class)bd.getType()));
        methodNode2.visitIntInsn(21, 2);
        methodNode2.visitVarInsn(25, 3);
        methodNode2.visitMethodInsn(182, classNode.name, SET_PROPERTY_VALUE_METHOD, methodDescriptor, false);
        methodNode2.visitInsn(177);
        methodNode2.visitEnd();
        return Lang.list((Object[])new MethodNode[]{methodNode, methodNode2});
    }

    private List<MethodNode> methodSetPropertyValueByName(ClassNode classNode, BeanDescriptor<?> bd) throws SecurityException {
        String methodName = SET_PROPERTY_VALUE_METHOD;
        String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Void.TYPE), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[]{org.objectweb.asm.Type.getType((Class)bd.getType()), org.objectweb.asm.Type.getType(String.class), org.objectweb.asm.Type.getType(Object.class)});
        MethodNode methodNode = new MethodNode(1, SET_PROPERTY_VALUE_METHOD, methodDescriptor, null, null);
        methodNode.visitVarInsn(25, 0);
        methodNode.visitVarInsn(25, 2);
        methodNode.visitMethodInsn(182, classNode.name, GET_PROPERTY_METHOD, GET_PROPERTY_DESCRIPTOR_BYNAME, false);
        methodNode.visitVarInsn(25, 1);
        methodNode.visitVarInsn(25, 3);
        methodNode.visitMethodInsn(185, org.objectweb.asm.Type.getInternalName(Property.class), SET, SET_DESCRIPTOR, true);
        methodNode.visitInsn(177);
        methodNode.visitEnd();
        MethodNode methodNode2 = new MethodNode(4161, SET_PROPERTY_VALUE_METHOD, SET_PROPERTY_DESCRIPTOR_BY_NAME, null, null);
        methodNode2.visitVarInsn(25, 0);
        methodNode2.visitVarInsn(25, 1);
        methodNode2.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName((Class)bd.getType()));
        methodNode2.visitVarInsn(25, 2);
        methodNode2.visitVarInsn(25, 3);
        methodNode2.visitMethodInsn(182, classNode.name, SET_PROPERTY_VALUE_METHOD, methodDescriptor, false);
        methodNode2.visitInsn(177);
        methodNode2.visitEnd();
        return Lang.list((Object[])new MethodNode[]{methodNode, methodNode2});
    }

    private MethodNode methodGetPropertyByIndex(ClassNode classNode, List<Class<?>> propertyTypes, BeanDescriptor<?> bd) throws NoSuchMethodException, SecurityException {
        String methodName = GET_PROPERTY_METHOD;
        String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)PropertyAccessor.class.getMethod(GET_PROPERTY_METHOD, Integer.TYPE));
        MethodNode methodNode = new MethodNode(1, GET_PROPERTY_METHOD, methodDescriptor, null, null);
        methodNode.visitIntInsn(21, 1);
        Label[] labels = new Label[propertyTypes.size()];
        for (int i = 0; i < propertyTypes.size(); ++i) {
            labels[i] = new Label();
        }
        Label labelDeft = new Label();
        methodNode.visitTableSwitchInsn(0, propertyTypes.size() - 1, labelDeft, labels);
        for (int i = 0; i < propertyTypes.size(); ++i) {
            FieldNode field = (FieldNode)classNode.fields.get(i);
            methodNode.visitLabel(labels[i]);
            methodNode.visitVarInsn(25, 0);
            methodNode.visitFieldInsn(180, classNode.name, field.name, field.desc);
            methodNode.visitInsn(176);
        }
        String exceptionBcnf = org.objectweb.asm.Type.getInternalName(NoSuchPropertyException.class);
        methodNode.visitLabel(labelDeft);
        methodNode.visitTypeInsn(187, exceptionBcnf);
        methodNode.visitInsn(89);
        methodNode.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)bd.getType()));
        methodNode.visitIntInsn(21, 1);
        methodNode.visitMethodInsn(183, exceptionBcnf, "<init>", Asm.getConstructorDescriptor(Class.class, Integer.TYPE), false);
        methodNode.visitInsn(191);
        methodNode.visitEnd();
        return methodNode;
    }

    private MethodNode methodGetPropertyByName(ClassNode classNode, List<Class<?>> propertyTypes, BeanDescriptor<?> bd) throws NoSuchMethodException, SecurityException {
        String methodName = GET_PROPERTY_METHOD;
        String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)PropertyAccessor.class.getMethod(GET_PROPERTY_METHOD, String.class));
        String exceptionBcnf = org.objectweb.asm.Type.getInternalName(NoSuchPropertyException.class);
        MethodNode methodNode = new MethodNode(1, GET_PROPERTY_METHOD, methodDescriptor, null, null);
        methodNode.visitVarInsn(25, 0);
        methodNode.visitFieldInsn(180, classNode.name, PROPERTY_MAP, MAP_DESCRIPTOR);
        methodNode.visitVarInsn(25, 1);
        methodNode.visitMethodInsn(182, MAP_NAME, GET, GET_DESCRIPTOR, false);
        methodNode.visitTypeInsn(192, org.objectweb.asm.Type.getInternalName(Property.class));
        methodNode.visitVarInsn(58, 2);
        methodNode.visitVarInsn(25, 2);
        Label labelNoneNull = new Label();
        methodNode.visitJumpInsn(199, labelNoneNull);
        methodNode.visitTypeInsn(187, exceptionBcnf);
        methodNode.visitInsn(89);
        methodNode.visitLdcInsn((Object)org.objectweb.asm.Type.getType((Class)bd.getType()));
        methodNode.visitVarInsn(25, 1);
        methodNode.visitMethodInsn(183, exceptionBcnf, "<init>", Asm.getConstructorDescriptor(Class.class, String.class), false);
        methodNode.visitInsn(191);
        methodNode.visitLabel(labelNoneNull);
        methodNode.visitVarInsn(25, 2);
        methodNode.visitInsn(176);
        methodNode.visitEnd();
        return methodNode;
    }

    private MethodNode methodGetProperties(ClassNode classNode) throws NoSuchMethodException, SecurityException {
        String methodName = "getProperties";
        String methodDescriptor = org.objectweb.asm.Type.getMethodDescriptor((Method)PropertyAccessor.class.getMethod("getProperties", new Class[0]));
        MethodNode methodNode = new MethodNode(1, "getProperties", methodDescriptor, null, null);
        methodNode.visitVarInsn(25, 0);
        methodNode.visitFieldInsn(180, classNode.name, PROPERTY_MAP, MAP_DESCRIPTOR);
        methodNode.visitMethodInsn(182, MAP_NAME, "values", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Collection.class), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), false);
        methodNode.visitVarInsn(25, 0);
        methodNode.visitFieldInsn(180, classNode.name, PROPERTY_MAP, MAP_DESCRIPTOR);
        methodNode.visitMethodInsn(182, MAP_NAME, "size", org.objectweb.asm.Type.getMethodDescriptor((org.objectweb.asm.Type)org.objectweb.asm.Type.getType(Integer.TYPE), (org.objectweb.asm.Type[])new org.objectweb.asm.Type[0]), false);
        methodNode.visitTypeInsn(189, org.objectweb.asm.Type.getInternalName(Property.class));
        methodNode.visitMethodInsn(185, org.objectweb.asm.Type.getInternalName(Collection.class), "toArray", "([Ljava/lang/Object;)[Ljava/lang/Object;", true);
        methodNode.visitTypeInsn(192, "[Lcn/featherfly/common/bean/Property;");
        methodNode.visitInsn(176);
        methodNode.visitEnd();
        return methodNode;
    }

    private String createClassName(Class<?> type) {
        return type.getName() + CLASS_NAME_SUFFIX;
    }

    protected void doClassLoaderReload() {
        this.manager.clear();
    }
}

