/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.bean;

import cn.featherfly.common.asm.Asm;
import cn.featherfly.common.asm.AsmException;
import cn.featherfly.common.bean.Instantiator;
import cn.featherfly.common.bean.InstantiatorFactory;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.BytesClassLoader;
import cn.featherfly.common.lang.ClassLoaderUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.ReloadableClassloader;
import java.lang.reflect.Method;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class AsmInstantiatorFactory
extends ReloadableClassloader
implements InstantiatorFactory {
    private final Map<Class<?>, Instantiator<?>> typeInstances = new HashMap(0);
    public static final String CLASS_NAME_SUFFIX = "InstantiatorByFeatherfly";
    private static final String METHOD_INSTANTIATE = "instantiate";
    private static final String METHOD_GETTYPE = "getType";
    private final BytesClassLoader bytesClassLoader;

    public AsmInstantiatorFactory(ClassLoader classLoader) {
        this.bytesClassLoader = new BytesClassLoader(classLoader);
    }

    public <T> Instantiator<T> create(Class<T> type, ClassLoader classLoader) {
        Instantiator instantiator = this.typeInstances.get(type);
        if (instantiator != null) {
            return instantiator;
        }
        try {
            Class<Instantiator<T>> newType = this.create0(type, classLoader);
            instantiator = (Instantiator)ClassUtils.newInstance(newType);
            this.typeInstances.put(type, instantiator);
            return instantiator;
        }
        catch (Exception e) {
            throw new AsmException(e);
        }
    }

    private <T> Class<Instantiator<T>> create0(Class<T> type, ClassLoader classLoader) throws NoSuchMethodException, SecurityException {
        type.getConstructor(ArrayUtils.EMPTY_CLASS_ARRAY);
        classLoader = this.prepare(classLoader);
        String instantiateType = Type.getInternalName(type);
        ClassWriter cw = new ClassWriter(1);
        String createdClassName = this.createClassName(type);
        String createdClassByteCodeName = Asm.getName(createdClassName);
        ClassNode classNode = new ClassNode();
        classNode.version = 52;
        classNode.access = 1;
        classNode.name = createdClassByteCodeName;
        classNode.superName = Type.getInternalName(Object.class);
        classNode.interfaces.add(Asm.getName(Instantiator.class));
        SignatureWriter signature = new SignatureWriter();
        SignatureVisitor instantiatorVisitor = signature.visitSuperclass();
        instantiatorVisitor.visitClassType((String)classNode.interfaces.get(0));
        SignatureVisitor typeVisitor = instantiatorVisitor.visitTypeArgument('=');
        typeVisitor.visitClassType(Type.getInternalName(type));
        typeVisitor.visitEnd();
        instantiatorVisitor.visitEnd();
        classNode.signature = signature.toString();
        MethodNode constructor = new MethodNode(1, "<init>", Asm.getConstructorDescriptor(), null, null);
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, classNode.superName, "<init>", Asm.getConstructorDescriptor(), false);
        constructor.visitInsn(177);
        constructor.visitMaxs(1, 1);
        constructor.visitEnd();
        classNode.methods.add(constructor);
        classNode.methods.add(AsmInstantiatorFactory.createMethodInstantiate(instantiateType));
        classNode.methods.add(AsmInstantiatorFactory.createMethodGetType(type));
        classNode.accept((ClassVisitor)cw);
        byte[] code = cw.toByteArray();
        return ClassLoaderUtils.defineClass((ClassLoader)classLoader, (String)createdClassName, (byte[])code, (ProtectionDomain)type.getProtectionDomain(), () -> this.bytesClassLoader.defineClass(createdClassName, code, type.getProtectionDomain()));
    }

    private String createClassName(Class<?> type) {
        return type.getName() + CLASS_NAME_SUFFIX;
    }

    public static MethodNode createMethodInstantiate(String typeInternalName) throws NoSuchMethodException, SecurityException {
        String methodDescriptor = Type.getMethodDescriptor((Method)Instantiator.class.getMethod(METHOD_INSTANTIATE, ArrayUtils.EMPTY_CLASS_ARRAY));
        MethodNode methodNode = new MethodNode(1, METHOD_INSTANTIATE, methodDescriptor, null, null);
        methodNode.parameters = new ArrayList();
        methodNode.visitTypeInsn(187, typeInternalName);
        methodNode.visitInsn(89);
        methodNode.visitMethodInsn(183, typeInternalName, "<init>", Asm.getConstructorDescriptor(), false);
        methodNode.visitInsn(176);
        methodNode.visitMaxs(2, 1);
        methodNode.visitEnd();
        return methodNode;
    }

    public static MethodNode createMethodGetType(Class<?> type) throws NoSuchMethodException, SecurityException {
        String methodDescriptor = Type.getMethodDescriptor((Method)Instantiator.class.getMethod(METHOD_GETTYPE, ArrayUtils.EMPTY_CLASS_ARRAY));
        MethodNode methodNode = new MethodNode(1, METHOD_GETTYPE, methodDescriptor, null, null);
        methodNode.parameters = new ArrayList();
        methodNode.visitLdcInsn((Object)Type.getType(type));
        methodNode.visitInsn(176);
        methodNode.visitMaxs(1, 1);
        methodNode.visitEnd();
        return methodNode;
    }

    protected void doClassLoaderReload() {
        this.typeInstances.clear();
    }
}

