/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.asm;

import cn.featherfly.common.exception.IOException;
import cn.featherfly.common.exception.UnsupportedException;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.ParameterNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Asm {
    private static final Map<Executable, String[]> METHOD_PARAMS = new HashMap<Executable, String[]>();
    private static final int SPACE_LEN = 20;
    public static final String CONSTRUCT_METHOD = "<init>";
    public static final String PRIMITIVE_BOXING_METHOD = "valueOf";
    @Deprecated
    public static final String PRIMITIVE_WRAPPER_METHOD = "valueOf";
    public static final String NONE_PARAMETER_DESCRIPTOR = "()V";
    private static final Map<Integer, String> OPCODE_MAP = new HashMap<Integer, String>();
    private static final Map<String, String> PRIMITIVE_UNBOXING_METHOD = new HashMap<String, String>();
    private static final Map<String, String> PRIMITIVE_UNBOXING_METHOD_DESCRIPTOR = new HashMap<String, String>();
    private static final Map<String, String> PRIMITIVE_BOXING_METHOD_DESCRIPTOR = new HashMap<String, String>();
    private static final Map<String, Class<?>> PRIMITIVE_WRAPPER = new HashMap();
    private static final Map<String, Type> PRIMITIVE_TYPE = new HashMap<String, Type>();
    private static final Map<Class<?>, Class<?>> WRAPPER_PRIMITIVE = new HashMap();

    public static String opcodeName(int opcode) {
        return Asm.opcodeName(opcode, false);
    }

    private static String opcodeName(int opcode, boolean appendSpace) {
        String result = OPCODE_MAP.get(opcode);
        if (result == null) {
            result = opcode + "";
        }
        if (appendSpace) {
            int appendSize = 20 - result.length();
            for (int i = 0; i < appendSize; ++i) {
                result = result + " ";
            }
        }
        return result;
    }

    public static String javapString(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode instanceof VarInsnNode) {
            VarInsnNode node = (VarInsnNode)abstractInsnNode;
            return Asm.opcodeName(node.getOpcode()) + "_" + node.var;
        }
        if (abstractInsnNode instanceof FieldInsnNode) {
            FieldInsnNode node = (FieldInsnNode)abstractInsnNode;
            return Asm.opcodeName(node.getOpcode(), true) + "// Field " + node.name + ":" + node.desc;
        }
        if (abstractInsnNode instanceof TypeInsnNode) {
            TypeInsnNode node = (TypeInsnNode)abstractInsnNode;
            return Asm.opcodeName(node.getOpcode(), true) + "// class " + node.desc;
        }
        if (abstractInsnNode instanceof InsnNode) {
            InsnNode node = (InsnNode)abstractInsnNode;
            return Asm.opcodeName(node.getOpcode());
        }
        if (abstractInsnNode instanceof LdcInsnNode) {
            LdcInsnNode node = (LdcInsnNode)abstractInsnNode;
            return Asm.opcodeName(node.getOpcode(), true) + "// " + node.cst.getClass().getSimpleName() + " " + node.cst;
        }
        if (abstractInsnNode instanceof MethodInsnNode) {
            MethodInsnNode node = (MethodInsnNode)abstractInsnNode;
            if (node.itf) {
                return Asm.opcodeName(node.getOpcode(), true) + "// InterfaceMethod " + node.owner + "." + node.name + ":" + node.desc;
            }
            return Asm.opcodeName(node.getOpcode(), true) + "// Method " + node.owner + "." + node.name + ":" + node.desc;
        }
        return abstractInsnNode.getClass().getName() + " " + Asm.opcodeName(abstractInsnNode.getOpcode()) + " " + abstractInsnNode.getOpcode();
    }

    public static String _getMethodDescriptor(Class<?> type) {
        return Type.getDescriptor(type);
    }

    public static String getConstructorDescriptor() {
        return NONE_PARAMETER_DESCRIPTOR;
    }

    public static String getConstructorDescriptor(Class<?> ... paramTypes) {
        if (Lang.isEmpty((Object[])paramTypes)) {
            return NONE_PARAMETER_DESCRIPTOR;
        }
        StringBuilder params = new StringBuilder();
        for (Class<?> type : paramTypes) {
            params.append(Asm._getMethodDescriptor(type));
        }
        return Strings.format((String)"({0})V", (Object)params.toString());
    }

    public static String getConstructorDescriptor(String ... paramTypeDescriptors) {
        if (Lang.isEmpty((Object[])paramTypeDescriptors)) {
            return NONE_PARAMETER_DESCRIPTOR;
        }
        StringBuilder params = new StringBuilder();
        for (String descriptors : paramTypeDescriptors) {
            params.append(descriptors);
        }
        return Strings.format((String)"({0})V", (Object)params.toString());
    }

    public static String getName(Class<?> type) {
        return Asm.getName(type.getName());
    }

    public static String getName(String className) {
        return className.replace('.', '/');
    }

    public static int getReturnCode(Class<?> type) {
        if (type.isPrimitive()) {
            return Asm.getPrimitiveReturnCode(type);
        }
        return 176;
    }

    public static int getPrimitiveReturnCode(Class<?> primitiveType) {
        if (primitiveType == Integer.TYPE) {
            return 172;
        }
        if (primitiveType == Byte.TYPE) {
            return 172;
        }
        if (primitiveType == Short.TYPE) {
            return 172;
        }
        if (primitiveType == Character.TYPE) {
            return 172;
        }
        if (primitiveType == Boolean.TYPE) {
            return 172;
        }
        if (primitiveType == Long.TYPE) {
            return 173;
        }
        if (primitiveType == Double.TYPE) {
            return 175;
        }
        if (primitiveType == Float.TYPE) {
            return 174;
        }
        return 177;
    }

    public static int getLoadCode(Class<?> primitiveType) {
        if (primitiveType == Integer.TYPE) {
            return 21;
        }
        if (primitiveType == Byte.TYPE) {
            return 21;
        }
        if (primitiveType == Short.TYPE) {
            return 21;
        }
        if (primitiveType == Character.TYPE) {
            return 21;
        }
        if (primitiveType == Boolean.TYPE) {
            return 21;
        }
        if (primitiveType == Long.TYPE) {
            return 22;
        }
        if (primitiveType == Double.TYPE) {
            return 24;
        }
        if (primitiveType == Float.TYPE) {
            return 23;
        }
        return 25;
    }

    public static String getPrimitiveUnboxingMethod(String type) {
        return PRIMITIVE_UNBOXING_METHOD.get(type);
    }

    public static String getPrimitiveUnboxingMethod(Class<?> type) {
        return PRIMITIVE_UNBOXING_METHOD.get(type.getName());
    }

    public static String getPrimitiveUnboxingMethodDescriptor(String type) {
        return PRIMITIVE_UNBOXING_METHOD_DESCRIPTOR.get(type);
    }

    public static String getPrimitiveUnboxingMethodDescriptor(Class<?> type) {
        return PRIMITIVE_UNBOXING_METHOD_DESCRIPTOR.get(type.getName());
    }

    public static String getPrimitiveBoxingMethodDescriptor(String type) {
        return PRIMITIVE_BOXING_METHOD_DESCRIPTOR.get(type);
    }

    public static String getPrimitiveBoxingMethodDescriptor(Class<?> type) {
        return PRIMITIVE_BOXING_METHOD_DESCRIPTOR.get(type.getName());
    }

    @Deprecated
    public static String getPrimitiveWrapperMethodDescriptor(String type) {
        return PRIMITIVE_BOXING_METHOD_DESCRIPTOR.get(type);
    }

    @Deprecated
    public static String getPrimitiveWrapperMethodDescriptor(Class<?> type) {
        return PRIMITIVE_BOXING_METHOD_DESCRIPTOR.get(type.getName());
    }

    public static Type getType(Class<?> type) {
        Type t = PRIMITIVE_TYPE.get(type.getName());
        if (t != null) {
            return t;
        }
        return Type.getType(type);
    }

    public static Type getType(String type) {
        Type t = PRIMITIVE_TYPE.get(type);
        if (t != null) {
            return t;
        }
        return Type.getObjectType((String)type);
    }

    public static boolean isPrimitive(String type) {
        return PRIMITIVE_WRAPPER.containsKey(type);
    }

    public static String getPrimitiveWrapperName(String type) {
        Class<?> c = PRIMITIVE_WRAPPER.get(type);
        if (c == null) {
            return Asm.getName(type);
        }
        return Type.getInternalName(c);
    }

    public static String getPrimitiveWrapperName(Class<?> type) {
        return Asm.getPrimitiveWrapperName(type.getName());
    }

    public static String[] getParamNames(Executable executable) {
        AssertIllegalArgument.isNotNull((Object)executable, (String)"executable");
        String[] names = METHOD_PARAMS.get(executable);
        if (names == null) {
            names = new String[executable.getParameterCount()];
            if (executable instanceof Constructor) {
                names = Asm._getConstructorParamNames((Constructor)executable);
            } else if (executable instanceof Method) {
                names = Asm._getMethodParamNames((Method)executable);
            } else {
                throw new UnsupportedException("not suppport for " + executable.getClass().getName());
            }
            METHOD_PARAMS.put(executable, names);
        }
        return names;
    }

    private static String[] _getMethodParamNames(Method method) {
        if (method == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (Lang.isEmpty((Object[])method.getParameterTypes())) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        boolean statics = Modifier.isStatic(method.getModifiers());
        String name = method.getName();
        String descriptor = Type.getMethodDescriptor((Method)method);
        Class<?> clazz = method.getDeclaringClass();
        ClassReader cr = Asm.classReader(clazz);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 8);
        MethodNode methodNode = Asm.getMethodNode(cn, descriptor, name);
        return Asm.getParamNames(methodNode, statics);
    }

    private static String[] _getConstructorParamNames(Constructor<?> constructor) {
        if (constructor == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (Lang.isEmpty((Object[])constructor.getParameterTypes())) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        boolean statics = Modifier.isStatic(constructor.getModifiers());
        String descriptor = Type.getConstructorDescriptor(constructor);
        Class<?> clazz = constructor.getDeclaringClass();
        ClassReader cr = Asm.classReader(clazz);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 8);
        MethodNode methodNode = Asm.getMethodNode(cn, descriptor, CONSTRUCT_METHOD);
        return Asm.getParamNames(methodNode, statics);
    }

    private static ClassReader classReader(Class<?> clazz) {
        try {
            return new ClassReader(clazz.getName());
        }
        catch (java.io.IOException e) {
            throw new IOException((Throwable)e);
        }
    }

    private static MethodNode getMethodNode(ClassNode classNode, String methodDescriptor, String methodName) {
        List methods = classNode.methods;
        for (MethodNode asmMethod : methods) {
            if (!asmMethod.desc.equals(methodDescriptor) || !asmMethod.name.equals(methodName)) continue;
            return asmMethod;
        }
        throw new RuntimeException("Method not found!");
    }

    private static String[] getParamNames(MethodNode asmMethod, boolean isStatic) {
        if (asmMethod.parameters != null) {
            String[] names = new String[asmMethod.parameters.size()];
            int index = 0;
            for (ParameterNode parameterNode : asmMethod.parameters) {
                names[index] = parameterNode.name;
                ++index;
            }
            return names;
        }
        if (asmMethod.localVariables != null) {
            TreeMap<Integer, String> names = new TreeMap<Integer, String>();
            for (LocalVariableNode variableNode : asmMethod.localVariables) {
                int index = variableNode.index;
                String name = variableNode.name;
                if (Asm.isThisVarName(isStatic, variableNode)) continue;
                names.put(index, name);
            }
            return names.values().toArray(new String[names.size()]);
        }
        return null;
    }

    private static boolean isThisVarName(boolean isStatic, LocalVariableNode variableNode) {
        if (isStatic) {
            return false;
        }
        int index = variableNode.index;
        String name = variableNode.name;
        return 0 == index && "this".equals(name);
    }

    static {
        boolean start = false;
        for (Field field : Opcodes.class.getFields()) {
            if (field.getName().equals("NOP")) {
                start = true;
            }
            if (!start) continue;
            Integer value = (Integer)ClassUtils.getFieldValue(Opcodes.class, (String)field.getName());
            OPCODE_MAP.put(value, field.getName().toLowerCase());
        }
        PRIMITIVE_UNBOXING_METHOD.put(Boolean.TYPE.getName(), "booleanValue");
        PRIMITIVE_UNBOXING_METHOD.put(Character.TYPE.getName(), "charValue");
        PRIMITIVE_UNBOXING_METHOD.put(Byte.TYPE.getName(), "byteValue");
        PRIMITIVE_UNBOXING_METHOD.put(Short.TYPE.getName(), "shortValue");
        PRIMITIVE_UNBOXING_METHOD.put(Integer.TYPE.getName(), "intValue");
        PRIMITIVE_UNBOXING_METHOD.put(Long.TYPE.getName(), "longValue");
        PRIMITIVE_UNBOXING_METHOD.put(Float.TYPE.getName(), "floatValue");
        PRIMITIVE_UNBOXING_METHOD.put(Double.TYPE.getName(), "doubleValue");
        PRIMITIVE_UNBOXING_METHOD_DESCRIPTOR.put(Boolean.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Boolean.class, (String)"booleanValue", (Class[])new Class[0])));
        PRIMITIVE_UNBOXING_METHOD_DESCRIPTOR.put(Character.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Character.class, (String)"charValue", (Class[])new Class[0])));
        PRIMITIVE_UNBOXING_METHOD_DESCRIPTOR.put(Byte.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Byte.class, (String)"byteValue", (Class[])new Class[0])));
        PRIMITIVE_UNBOXING_METHOD_DESCRIPTOR.put(Short.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Short.class, (String)"shortValue", (Class[])new Class[0])));
        PRIMITIVE_UNBOXING_METHOD_DESCRIPTOR.put(Integer.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Integer.class, (String)"intValue", (Class[])new Class[0])));
        PRIMITIVE_UNBOXING_METHOD_DESCRIPTOR.put(Long.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Long.class, (String)"longValue", (Class[])new Class[0])));
        PRIMITIVE_UNBOXING_METHOD_DESCRIPTOR.put(Float.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Float.class, (String)"floatValue", (Class[])new Class[0])));
        PRIMITIVE_UNBOXING_METHOD_DESCRIPTOR.put(Double.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Double.class, (String)"doubleValue", (Class[])new Class[0])));
        PRIMITIVE_BOXING_METHOD_DESCRIPTOR.put(Boolean.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Boolean.class, (String)"valueOf", (Class[])new Class[]{Boolean.TYPE})));
        PRIMITIVE_BOXING_METHOD_DESCRIPTOR.put(Character.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Character.class, (String)"valueOf", (Class[])new Class[]{Character.TYPE})));
        PRIMITIVE_BOXING_METHOD_DESCRIPTOR.put(Byte.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Byte.class, (String)"valueOf", (Class[])new Class[]{Byte.TYPE})));
        PRIMITIVE_BOXING_METHOD_DESCRIPTOR.put(Short.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Short.class, (String)"valueOf", (Class[])new Class[]{Short.TYPE})));
        PRIMITIVE_BOXING_METHOD_DESCRIPTOR.put(Integer.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Integer.class, (String)"valueOf", (Class[])new Class[]{Integer.TYPE})));
        PRIMITIVE_BOXING_METHOD_DESCRIPTOR.put(Long.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Long.class, (String)"valueOf", (Class[])new Class[]{Long.TYPE})));
        PRIMITIVE_BOXING_METHOD_DESCRIPTOR.put(Float.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Float.class, (String)"valueOf", (Class[])new Class[]{Float.TYPE})));
        PRIMITIVE_BOXING_METHOD_DESCRIPTOR.put(Double.TYPE.getName(), Type.getMethodDescriptor((Method)ClassUtils.getMethod(Double.class, (String)"valueOf", (Class[])new Class[]{Double.TYPE})));
        PRIMITIVE_WRAPPER.put(Boolean.TYPE.getName(), Boolean.class);
        PRIMITIVE_WRAPPER.put(Character.TYPE.getName(), Character.class);
        PRIMITIVE_WRAPPER.put(Byte.TYPE.getName(), Byte.class);
        PRIMITIVE_WRAPPER.put(Short.TYPE.getName(), Short.class);
        PRIMITIVE_WRAPPER.put(Integer.TYPE.getName(), Integer.class);
        PRIMITIVE_WRAPPER.put(Long.TYPE.getName(), Long.class);
        PRIMITIVE_WRAPPER.put(Float.TYPE.getName(), Float.class);
        PRIMITIVE_WRAPPER.put(Double.TYPE.getName(), Double.class);
        PRIMITIVE_WRAPPER.put(Void.TYPE.getName(), Void.class);
        WRAPPER_PRIMITIVE.put(Boolean.class, Boolean.TYPE);
        WRAPPER_PRIMITIVE.put(Character.class, Character.TYPE);
        WRAPPER_PRIMITIVE.put(Byte.class, Byte.TYPE);
        WRAPPER_PRIMITIVE.put(Short.class, Short.TYPE);
        WRAPPER_PRIMITIVE.put(Integer.class, Integer.TYPE);
        WRAPPER_PRIMITIVE.put(Long.class, Long.TYPE);
        WRAPPER_PRIMITIVE.put(Float.class, Float.TYPE);
        WRAPPER_PRIMITIVE.put(Double.class, Double.TYPE);
        WRAPPER_PRIMITIVE.put(Void.class, Void.TYPE);
        PRIMITIVE_TYPE.put(Boolean.TYPE.getName(), Type.BOOLEAN_TYPE);
        PRIMITIVE_TYPE.put(Character.TYPE.getName(), Type.CHAR_TYPE);
        PRIMITIVE_TYPE.put(Byte.TYPE.getName(), Type.BYTE_TYPE);
        PRIMITIVE_TYPE.put(Short.TYPE.getName(), Type.SHORT_TYPE);
        PRIMITIVE_TYPE.put(Integer.TYPE.getName(), Type.INT_TYPE);
        PRIMITIVE_TYPE.put(Long.TYPE.getName(), Type.LONG_TYPE);
        PRIMITIVE_TYPE.put(Float.TYPE.getName(), Type.FLOAT_TYPE);
        PRIMITIVE_TYPE.put(Double.TYPE.getName(), Type.DOUBLE_TYPE);
    }
}

