/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.common.asm;

import cn.featherfly.common.exception.IOException;
import cn.featherfly.common.lang.ArrayUtils;
import cn.featherfly.common.lang.ClassUtils;
import cn.featherfly.common.lang.Lang;
import cn.featherfly.common.lang.Strings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class Asm {
    private static final int SPACE_LEN = 20;
    public static final String CONSTRUCT_METHOD = "<init>";
    public static final String NONE_PARAMETER_DESCRIPTOR = "()V";
    public static final Map<Integer, String> OPCODE_MAP = new HashMap<Integer, String>();

    public static String opcodeName(int opcode) {
        return Asm.opcodeName(opcode, false);
    }

    private static String opcodeName(int opcode, boolean appendSpace) {
        String result = OPCODE_MAP.get(opcode);
        if (result == null) {
            result = opcode + "";
        }
        if (appendSpace) {
            int appendSize = 20 - result.length();
            for (int i = 0; i < appendSize; ++i) {
                result = result + " ";
            }
        }
        return result;
    }

    public static String javapString(AbstractInsnNode abstractInsnNode) {
        if (abstractInsnNode instanceof VarInsnNode) {
            VarInsnNode node = (VarInsnNode)abstractInsnNode;
            return Asm.opcodeName(node.getOpcode()) + "_" + node.var;
        }
        if (abstractInsnNode instanceof FieldInsnNode) {
            FieldInsnNode node = (FieldInsnNode)abstractInsnNode;
            return Asm.opcodeName(node.getOpcode(), true) + "// Field " + node.name + ":" + node.desc;
        }
        if (abstractInsnNode instanceof TypeInsnNode) {
            TypeInsnNode node = (TypeInsnNode)abstractInsnNode;
            return Asm.opcodeName(node.getOpcode(), true) + "// class " + node.desc;
        }
        if (abstractInsnNode instanceof InsnNode) {
            InsnNode node = (InsnNode)abstractInsnNode;
            return Asm.opcodeName(node.getOpcode());
        }
        if (abstractInsnNode instanceof LdcInsnNode) {
            LdcInsnNode node = (LdcInsnNode)abstractInsnNode;
            return Asm.opcodeName(node.getOpcode(), true) + "// " + node.cst.getClass().getSimpleName() + " " + node.cst;
        }
        if (abstractInsnNode instanceof MethodInsnNode) {
            MethodInsnNode node = (MethodInsnNode)abstractInsnNode;
            if (node.itf) {
                return Asm.opcodeName(node.getOpcode(), true) + "// InterfaceMethod " + node.owner + "." + node.name + ":" + node.desc;
            }
            return Asm.opcodeName(node.getOpcode(), true) + "// Method " + node.owner + "." + node.name + ":" + node.desc;
        }
        return abstractInsnNode.getClass().getName() + " " + Asm.opcodeName(abstractInsnNode.getOpcode()) + " " + abstractInsnNode.getOpcode();
    }

    public static String _getMethodDescriptor(Class<?> type) {
        return Type.getDescriptor(type);
    }

    public static String getConstructorDescriptor(Class<?> ... paramTypes) {
        if (Lang.isEmpty((Object[])paramTypes)) {
            return NONE_PARAMETER_DESCRIPTOR;
        }
        StringBuilder params = new StringBuilder();
        for (Class<?> type : paramTypes) {
            params.append(Asm._getMethodDescriptor(type));
        }
        return Strings.format((String)"({0})V", (Object)params.toString());
    }

    public static String getName(Class<?> type) {
        return Asm.getName(type.getName());
    }

    public static String getName(String className) {
        return className.replace('.', '/');
    }

    public static String[] getParamNames(Method method) {
        if (method == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (Lang.isEmpty((Object[])method.getParameterTypes())) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        boolean statics = Modifier.isStatic(method.getModifiers());
        String name = method.getName();
        String descriptor = Type.getMethodDescriptor((Method)method);
        Class<?> clazz = method.getDeclaringClass();
        ClassReader cr = Asm.classReader(clazz);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 8);
        MethodNode methodNode = Asm.getMethodNode(cn, descriptor, name);
        return Asm.getParamNames(methodNode, statics);
    }

    public static String[] getParamNames(Constructor<?> constructor) {
        if (constructor == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (Lang.isEmpty((Object[])constructor.getParameterTypes())) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        boolean statics = Modifier.isStatic(constructor.getModifiers());
        String descriptor = Type.getConstructorDescriptor(constructor);
        Class<?> clazz = constructor.getDeclaringClass();
        ClassReader cr = Asm.classReader(clazz);
        ClassNode cn = new ClassNode();
        cr.accept((ClassVisitor)cn, 8);
        MethodNode methodNode = Asm.getMethodNode(cn, descriptor, CONSTRUCT_METHOD);
        return Asm.getParamNames(methodNode, statics);
    }

    private static ClassReader classReader(Class<?> clazz) {
        try {
            return new ClassReader(clazz.getName());
        }
        catch (java.io.IOException e) {
            throw new IOException((Throwable)e);
        }
    }

    private static MethodNode getMethodNode(ClassNode classNode, String methodDescriptor, String methodName) {
        List methods = classNode.methods;
        for (MethodNode asmMethod : methods) {
            if (!asmMethod.desc.equals(methodDescriptor) || !asmMethod.name.equals(methodName)) continue;
            return asmMethod;
        }
        throw new RuntimeException("Method not found!");
    }

    private static String[] getParamNames(MethodNode asmMethod, boolean isStatic) {
        List localVariableNodes = asmMethod.localVariables;
        TreeMap<Integer, String> names = new TreeMap<Integer, String>();
        for (LocalVariableNode variableNode : localVariableNodes) {
            int index = variableNode.index;
            String name = variableNode.name;
            if (Asm.isThisVarName(isStatic, variableNode)) continue;
            names.put(index, name);
        }
        return names.values().toArray(new String[names.size()]);
    }

    private static boolean isThisVarName(boolean isStatic, LocalVariableNode variableNode) {
        if (isStatic) {
            return false;
        }
        int index = variableNode.index;
        String name = variableNode.name;
        return 0 == index && "this".equals(name);
    }

    static {
        boolean start = false;
        for (Field field : Opcodes.class.getFields()) {
            if (field.getName().equals("NOP")) {
                start = true;
            }
            if (!start) continue;
            Integer value = (Integer)ClassUtils.getFieldValue(Opcodes.class, (String)field.getName());
            OPCODE_MAP.put(value, field.getName().toLowerCase());
        }
    }
}

