/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.authorities.web.springmvc;

import cn.featherfly.authorities.BusinessRole;
import cn.featherfly.authorities.CustomRole;
import cn.featherfly.authorities.Role;
import cn.featherfly.authorities.RoleDefiner;
import cn.featherfly.authorities.RoleDefinerManager;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class RoleDefinerManagerSpringImpl
implements RoleDefinerManager,
ApplicationContextAware {
    private Map<String, RoleDefiner> roleDefinerMap;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.roleDefinerMap = applicationContext.getBeansOfType(RoleDefiner.class);
    }

    public List<RoleDefiner<Role>> getRoleDefiners() {
        return this.roleDefinerMap.values().stream().map(r -> r).collect(Collectors.toList());
    }

    public List<RoleDefiner<BusinessRole>> getBusinessRoleDefiners() {
        return this.roleDefinerMap.values().stream().filter(r -> r.support(BusinessRole.class)).map(r -> r).collect(Collectors.toList());
    }

    public List<RoleDefiner<CustomRole>> getCustomRoleDefiners() {
        return this.roleDefinerMap.values().stream().filter(r -> r.support(CustomRole.class)).map(r -> r).collect(Collectors.toList());
    }
}

