/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.authorities.web.login;

import cn.featherfly.authorities.Actor;
import cn.featherfly.authorities.AuthorityException;
import cn.featherfly.authorities.login.LoginEvent;
import cn.featherfly.authorities.login.LoginInfo;
import cn.featherfly.authorities.login.LoginListener;
import cn.featherfly.authorities.web.authentication.WebAuthenticator;
import cn.featherfly.authorities.web.login.WebActorLoginStorage;
import cn.featherfly.authorities.web.login.WebLoginInfo;
import cn.featherfly.authorities.web.login.WebLoginManager;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.web.servlet.ServletUtils;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWebLoginManager<W extends WebLoginInfo<A>, A extends Actor>
implements WebLoginManager<W, A> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private WebActorLoginStorage<W, A> webActorLoginStorage;
    private List<LoginListener<W, A>> loginListeners = new ArrayList<LoginListener<W, A>>();
    private boolean sameOnline;
    private boolean checkCrossSession;
    private List<WebAuthenticator> authenticators = new ArrayList<WebAuthenticator>();

    public void login(A actor, HttpServletRequest request) {
        this.logger.debug("\u767b\u5f55: {}", (Object)actor.getDescp());
        if (LangUtils.isEmpty(this.authenticators)) {
            throw new AuthorityException("#authenticators.null");
        }
        for (WebAuthenticator authenticator : this.authenticators) {
            authenticator.authenticate(actor, request);
        }
        String key = this.getKey(request);
        LoginInfo info = this.webActorLoginStorage.getLoginInfo(key);
        if (info != null && this.checkCrossSession && !info.getActor().getId().equals(actor.getId())) {
            this.logger.debug("\u5f53\u524d\u4f1a\u8bdd\u5df2\u7ecf\u5b58\u5728\u767b\u5f55\u7528\u6237{}\uff0c\u6ce8\u9500\u767b\u5f55\u7528\u6237{}\u5e76\u767b\u5f55\u5f53\u524d\u7528\u6237{}", new Object[]{info.getActor().getName(), info.getActor().getName(), actor.getDescp()});
            this.logout((A)info.getActor());
        }
        if (!this.isSameOnline() && this.isLogin(actor)) {
            this.logger.debug("{}\u5df2\u7ecf\u767b\u5f55\uff0c\u6ce8\u9500\u4e4b\u524d\u7684\u767b\u5f55\u4fe1\u606f\u5e76\u91cd\u65b0\u767b\u5f55", (Object)actor.getDescp());
            this.logout(actor);
        }
        this.webActorLoginStorage.store(key, actor);
        W webLoginInfo = this.getLoginInfo((A)request);
        ((WebLoginInfo)((Object)webLoginInfo)).setIp(ServletUtils.getIpAddr((HttpServletRequest)request));
        LoginEvent loginEvent = new LoginEvent();
        loginEvent.setLoginInfo(webLoginInfo);
        for (LoginListener<W, A> loginListener : this.loginListeners) {
            loginListener.onLogin(loginEvent);
        }
    }

    protected abstract String getKey(HttpServletRequest var1);

    public boolean isLogin(HttpServletRequest request) {
        return this.webActorLoginStorage.containsKey(request.getSession().getId());
    }

    public boolean isLogin(A actor) {
        return this.getLoginInfo((Actor)actor) != null;
    }

    public void logout(HttpServletRequest request) {
        this.logout(request.getSession());
    }

    @Override
    public void logout(HttpSession session) {
        W webLoginInfo;
        if (this.logger.isDebugEnabled() && (webLoginInfo = this.getLoginInfo((A)session)) != null) {
            this.logger.debug("\u6ce8\u9500\uff1a{}", (Object)webLoginInfo.getActor().getDescp());
        }
        this.webActorLoginStorage.remove(session.getId());
    }

    public void logout(A actor) {
        if (actor != null) {
            this.logger.debug("\u6ce8\u9500\uff1a{}", (Object)actor.getDescp());
            this.webActorLoginStorage.remove(actor);
        }
    }

    public List<A> getLoginActors() {
        return this.webActorLoginStorage.getLoginActors();
    }

    public W getLoginInfo(HttpServletRequest request) {
        return this.getLoginInfo((A)request.getSession());
    }

    @Override
    public W getLoginInfo(HttpSession session) {
        return (W)this.webActorLoginStorage.getLoginInfo(session.getId());
    }

    public W getLoginInfo(A actor) {
        return (W)this.webActorLoginStorage.getLoginInfo((Actor)actor);
    }

    public List<W> getLoginInfos() {
        return this.webActorLoginStorage.getLoginInfos();
    }

    public void addLoginListener(LoginListener<W, A> loginListener) {
        this.loginListeners.add(loginListener);
    }

    public boolean isSameOnline() {
        return this.sameOnline;
    }

    public void setSameOnline(boolean sameOnline) {
        this.sameOnline = sameOnline;
    }

    public void setWebActorLoginStorage(WebActorLoginStorage<W, A> webActorLoginStorage) {
        this.webActorLoginStorage = webActorLoginStorage;
    }

    public void setLoginListeners(List<LoginListener<W, A>> loginListeners) {
        this.loginListeners = loginListeners;
    }

    public List<WebAuthenticator> getAuthenticators() {
        return this.authenticators;
    }

    public void setAuthenticators(List<WebAuthenticator> authenticators) {
        this.authenticators = authenticators;
    }

    public boolean isCheckCrossSession() {
        return this.checkCrossSession;
    }

    public void setCheckCrossSession(boolean checkCrossSession) {
        this.checkCrossSession = checkCrossSession;
    }
}

