/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.authorities.web.authentication;

import cn.featherfly.authorities.Actor;
import cn.featherfly.authorities.AuthorityException;
import cn.featherfly.authorities.authentication.AuthenticationException;
import cn.featherfly.authorities.web.authentication.WebAuthenticator;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.locale.ResourceBundleUtils;
import cn.featherfly.common.validate.SimpleValidateCodeGenerator;
import cn.featherfly.common.validate.ValidateCode;
import cn.featherfly.common.validate.ValidateCodeGenerator;
import cn.featherfly.common.validate.ValidateCodeUtils;
import java.io.IOException;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ValidateCodeAuthenticator<A extends Actor>
implements WebAuthenticator<A> {
    private String validateCodeKey = "VALIDATE_CODE";
    private boolean caseSensitive;
    private int imageHight = 80;
    private int imageWith = 200;
    private ValidateCodeGenerator validateCodeGenerator;

    public ValidateCodeAuthenticator() {
        SimpleValidateCodeGenerator g = new SimpleValidateCodeGenerator();
        g.setSize(4);
        this.validateCodeGenerator = g;
    }

    @Override
    public void authenticate(A actor, HttpServletRequest request) {
        Object valid;
        String clientValidateCode = request.getParameter(this.validateCodeKey);
        if (LangUtils.isEmpty((String)clientValidateCode) && (valid = request.getAttribute(this.validateCodeKey)) != null) {
            clientValidateCode = valid.toString();
        }
        ValidateCode validateCode = this.getGeneratedValidCode(request);
        if (LangUtils.isNotEmpty((String)clientValidateCode) && validateCode != null && (this.caseSensitive ? clientValidateCode.equals(validateCode.getValid()) : clientValidateCode.equalsIgnoreCase(validateCode.getValid().toString()))) {
            return;
        }
        throw new AuthenticationException(ResourceBundleUtils.getString(AuthorityException.class, (String)"validateCode.error"));
    }

    public void setClientValidateCode(HttpServletRequest request, String validCode) {
        request.setAttribute(this.validateCodeKey, (Object)validCode);
    }

    public String getClientValidateCode(HttpServletRequest request) {
        Object valid;
        String clientValidateCode = request.getParameter(this.validateCodeKey);
        if (LangUtils.isEmpty((String)clientValidateCode) && (valid = request.getAttribute(this.validateCodeKey)) != null) {
            clientValidateCode = valid.toString();
        }
        return clientValidateCode;
    }

    public void setGeneratedValidCode(HttpServletRequest request, ValidateCode validCode) {
        request.getSession().setAttribute(this.validateCodeKey, (Object)validCode);
    }

    public ValidateCode getGeneratedValidCode(HttpServletRequest request) {
        return (ValidateCode)request.getSession().getAttribute(this.validateCodeKey);
    }

    public void generateValidCodeImage(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "no-cache");
        response.setDateHeader("Expires", 0L);
        response.setContentType("image/jpeg");
        ValidateCode validateCode = this.validateCodeGenerator.generate();
        this.setGeneratedValidCode(request, validateCode);
        ValidateCodeUtils.outputImage((int)this.imageWith, (int)this.imageHight, (OutputStream)response.getOutputStream(), (String)validateCode.getShow());
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public String getValidateCodeKey() {
        return this.validateCodeKey;
    }

    public void setValidateCodeKey(String validateCodeKey) {
        this.validateCodeKey = validateCodeKey;
    }

    public ValidateCodeGenerator getValidateCodeGenerator() {
        return this.validateCodeGenerator;
    }

    public void setValidateCodeGenerator(ValidateCodeGenerator validateCodeGenerator) {
        this.validateCodeGenerator = validateCodeGenerator;
    }

    public int getImageHight() {
        return this.imageHight;
    }

    public void setImageHight(int imageHight) {
        this.imageHight = imageHight;
    }

    public int getImageWith() {
        return this.imageWith;
    }

    public void setImageWith(int imageWith) {
        this.imageWith = imageWith;
    }
}

