/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.authorities.web.authentication;

import cn.featherfly.authorities.web.authentication.AuthenticationKeyTokenImpl;
import cn.featherfly.authorities.web.authentication.AuthenticationKeyTokenWithRequestParamImpl;
import cn.featherfly.authorities.web.authentication.AuthenticationToken;
import cn.featherfly.authorities.web.authentication.AuthenticationTokenFactory;
import cn.featherfly.authorities.web.authentication.SimpleAuthenticationToken;
import cn.featherfly.common.lang.LangUtils;
import javax.servlet.http.HttpServletRequest;

public class AuthenticationTokenFactoryImpl
implements AuthenticationTokenFactory {
    private AuthenticationTokens type = AuthenticationTokens.SimpleAuthenticationToken;

    public AuthenticationTokens getType() {
        return this.type;
    }

    public void setType(AuthenticationTokens type) {
        this.type = type;
    }

    @Override
    public AuthenticationToken create(HttpServletRequest request) {
        String signature;
        String ak = request.getHeader("ak");
        if (LangUtils.isEmpty((String)ak)) {
            ak = request.getParameter("ak");
        }
        if (LangUtils.isEmpty((String)(signature = request.getHeader("signature")))) {
            signature = request.getParameter("signature");
        }
        switch (this.type) {
            case AuthenticationKeyToken: {
                return new AuthenticationKeyTokenImpl(signature, ak);
            }
            case AuthenticationKeyTokenWithRequestParam: {
                return new AuthenticationKeyTokenWithRequestParamImpl(signature, ak);
            }
        }
        String token = request.getHeader("token");
        if (LangUtils.isEmpty((String)token)) {
            token = request.getParameter("token");
        }
        return new SimpleAuthenticationToken(token);
    }

    public static enum AuthenticationTokens {
        SimpleAuthenticationToken,
        AuthenticationKeyToken,
        AuthenticationKeyTokenWithRequestParam;

    }
}

