/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.authorities.web.authentication;

import cn.featherfly.authorities.authentication.AuthenticationException;
import cn.featherfly.authorities.web.authentication.AbstractAuthenticationKeyToken;
import cn.featherfly.common.algorithm.Base64;
import cn.featherfly.common.algorithm.MD5;
import cn.featherfly.common.algorithm.SHA;
import cn.featherfly.common.lang.AssertIllegalArgument;
import cn.featherfly.common.lang.LangUtils;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.springframework.http.MediaType;

public class AuthenticationKeyTokenWithRequestParamImpl
extends AbstractAuthenticationKeyToken {
    private Charset requestEncoding = StandardCharsets.UTF_8;

    public AuthenticationKeyTokenWithRequestParamImpl(String signature, String authenticationKey) {
        this.setSignature(signature);
        this.setAuthenticationKey(authenticationKey);
    }

    public AuthenticationKeyTokenWithRequestParamImpl(String token, String identity, Long timestamp, String requestDescp) {
        this.setSignature(token, timestamp, requestDescp);
        this.setAuthenticationKey(identity, timestamp, requestDescp);
    }

    public void setAuthenticationKey(String authenticationKey) {
        this.authenticationKey = authenticationKey;
        try {
            String[] aks = this.decodeAuthenticationKey(authenticationKey);
            this.identity = aks[0];
            this.timestamp = Long.parseLong(aks[1].trim());
        }
        catch (Exception e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    @Override
    public boolean verify(String token) {
        AssertIllegalArgument.isNotEmpty((String)this.signature, (String)"signature\u4e0d\u80fd\u4e3a\u7a7a");
        AssertIllegalArgument.isNotEmpty((String)this.authenticationKey, (String)"authenticationKey\u4e0d\u80fd\u4e3a\u7a7a");
        String[] akvs = this.decodeAuthenticationKey(this.authenticationKey);
        return this.generateSignature(token, Long.parseLong(akvs[1]), akvs[2], false).equals(this.signature);
    }

    public boolean verifyRequest(String token, HttpServletRequest request) {
        AssertIllegalArgument.isNotEmpty((String)this.signature, (String)"signature");
        AssertIllegalArgument.isNotEmpty((String)this.authenticationKey, (String)"authenticationKey");
        String requestDescp = this.getRequestDescp(request);
        String[] akvs = this.decodeAuthenticationKey(this.authenticationKey);
        return this.generateSignature(token, Long.parseLong(akvs[1]), requestDescp, true).equals(this.signature);
    }

    public String getRequestDescp(HttpServletRequest request) {
        String requestDescp = null;
        requestDescp = LangUtils.isNotEmpty((String)request.getContentType()) && MediaType.APPLICATION_JSON.includes(MediaType.parseMediaType((String)request.getContentType())) ? request.getRequestURL() + "?" + this.getRequestBody(request) : this.createRequestDescpWithParameter(request);
        return requestDescp;
    }

    private String[] decodeAuthenticationKey(String authenticationKey) {
        String akv;
        try {
            akv = Base64.decryptToString((String)authenticationKey);
        }
        catch (Exception e) {
            throw new AuthenticationException((Throwable)e);
        }
        String[] akvs = akv.split(this.akSplitSign);
        if (akvs.length != 3) {
            throw new AuthenticationException("\u975e\u6cd5\u8bf7\u6c42");
        }
        return akvs;
    }

    private String createRequestDescpWithParameter(HttpServletRequest request) {
        String queryParamStr = this.getParameters(request);
        if (LangUtils.isNotEmpty((String)queryParamStr)) {
            queryParamStr = "?" + queryParamStr;
        }
        String requestDescp = request.getRequestURL() + queryParamStr;
        return requestDescp;
    }

    private String getParameters(HttpServletRequest request) {
        StringBuilder params = new StringBuilder();
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object[] values = request.getParameterValues(name);
            if (!LangUtils.isNotEmpty((Object[])values)) continue;
            for (Object value : values) {
                if (null == value) {
                    value = "";
                }
                params.append(name).append("=").append((String)value).append("&");
            }
        }
        if (params.length() > 0) {
            params.deleteCharAt(params.length() - 1);
        }
        return params.toString();
    }

    private String getRequestBody(HttpServletRequest servletRequest) {
        String charset = servletRequest.getCharacterEncoding() == null ? StandardCharsets.UTF_8.displayName() : servletRequest.getCharacterEncoding();
        try {
            return IOUtils.toString((InputStream)servletRequest.getInputStream(), (String)charset);
        }
        catch (IOException e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    public void setSignature(String token, Long timestamp, String requestDescp) {
        this.setSignature(this.generateSignature(token, timestamp, requestDescp, true));
    }

    private String generateSignature(String token, Long timestamp, String requestDescp, boolean isOriginalRequestDescp) {
        try {
            if (isOriginalRequestDescp) {
                requestDescp = MD5.encrypt((String)requestDescp);
            }
            return SHA.encrypt((String)(token + timestamp + MD5.encrypt((String)(timestamp + requestDescp))));
        }
        catch (Exception e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    public void setAuthenticationKey(String identity, Long timestamp, String requestDescp) {
        this.setAuthenticationKey(this.generateAuthenticationKey(identity, timestamp, requestDescp));
        this.identity = identity;
    }

    private String generateAuthenticationKey(String identity, Long timestamp, String requestDescp) {
        try {
            return Base64.encryptToString((String)(identity + this.akSplitSign + timestamp + this.akSplitSign + MD5.encrypt((String)requestDescp)));
        }
        catch (Exception e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    public Charset getRequestEncoding() {
        return this.requestEncoding;
    }

    public void setRequestEncoding(Charset requestEncoding) {
        this.requestEncoding = requestEncoding;
    }
}

