/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.authorities.web.authentication;

import cn.featherfly.authorities.authentication.AuthenticationException;
import cn.featherfly.authorities.web.authentication.AbstractAuthenticationKeyToken;
import cn.featherfly.common.algorithm.Base64;
import cn.featherfly.common.algorithm.SHA;
import cn.featherfly.common.lang.AssertIllegalArgument;

public class AuthenticationKeyTokenImpl
extends AbstractAuthenticationKeyToken {
    public AuthenticationKeyTokenImpl(String signature, String authenticationKey) {
        this.setSignature(signature);
        this.setAuthenticationKey(authenticationKey);
    }

    public AuthenticationKeyTokenImpl(String token, String identity, Long timestamp) {
        this.setSignature(token, timestamp);
        this.setAuthenticationKey(identity, timestamp);
    }

    public void setAuthenticationKey(String authenticationKey) {
        this.authenticationKey = authenticationKey;
        String[] aks = this.decodeAuthenticationKey(authenticationKey);
        this.identity = aks[0];
        this.timestamp = Long.parseLong(aks[1].trim());
    }

    @Override
    public boolean verify(String token) {
        AssertIllegalArgument.isNotEmpty((String)this.signature, (String)"signature");
        AssertIllegalArgument.isNotEmpty((String)this.authenticationKey, (String)"authenticationKey");
        String[] akvs = this.decodeAuthenticationKey(this.authenticationKey);
        try {
            return SHA.encrypt((String)(token + akvs[1])).equals(this.signature);
        }
        catch (Exception e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    public void setSignature(String token, Long timestamp) {
        try {
            this.setSignature(SHA.encrypt((String)(token + timestamp)));
        }
        catch (Exception e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    public void setAuthenticationKey(String identity, Long timestamp) {
        try {
            this.setAuthenticationKey(Base64.encryptToString((String)(identity + this.akSplitSign + timestamp)));
            this.identity = identity;
        }
        catch (Exception e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    private String[] decodeAuthenticationKey(String authenticationKey) {
        try {
            return Base64.decryptToString((String)authenticationKey).split(this.akSplitSign);
        }
        catch (Exception e) {
            throw new AuthenticationException((Throwable)e);
        }
    }
}

