/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.authorities.web;

import cn.featherfly.authorities.Actor;
import cn.featherfly.authorities.Authority;
import cn.featherfly.authorities.AuthorityChecker;
import cn.featherfly.authorities.AuthorityException;
import cn.featherfly.authorities.web.AbstractChecker;
import cn.featherfly.authorities.web.WebAuthorityFacotry;
import cn.featherfly.authorities.web.WebEnv;
import cn.featherfly.authorities.web.login.WebLoginInfo;
import cn.featherfly.authorities.web.login.WebLoginManager;
import cn.featherfly.common.lang.LangUtils;
import cn.featherfly.common.locale.ResourceBundleUtils;
import cn.featherfly.web.spring.servlet.view.Result;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebAuthorityChecker
extends AbstractChecker
implements AuthorityChecker<WebEnv> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private WebLoginManager<?, ?> loginManager;
    private String redirectURL;
    private boolean autoRedirect;
    private WebAuthorityFacotry facotry;

    @Override
    protected boolean doCheck(HttpServletRequest request, HttpServletResponse response, String uri) {
        Actor actor;
        Result result = new Result();
        result.setStatus(Integer.valueOf(0));
        Authority authority = this.facotry.create(request);
        if (authority != null && !(actor = ((WebLoginInfo)this.loginManager.getLoginInfo(request)).getActor()).hasAuthority(authority)) {
            String authorityName = authority.getName();
            if (LangUtils.isEmpty((String)authorityName)) {
                authorityName = request.getMethod().toUpperCase() + ":" + uri;
            }
            result.setMessage(ResourceBundleUtils.getString(AuthorityException.class, (String)"authority.not.auth", (Object[])new Object[]{authorityName}));
            if (request.getHeader("Accept").contains("application/json")) {
                response.setStatus(403);
                this.render(response, result);
            } else {
                String location = this.redirectURL;
                if (LangUtils.isEmpty((String)location)) {
                    location = request.getHeader("Referer");
                }
                try {
                    if (this.autoRedirect && LangUtils.isNotEmpty((String)location)) {
                        response.sendRedirect(location);
                    } else {
                        response.sendError(403, result.getMessage());
                    }
                }
                catch (IOException e) {
                    throw new AuthorityException((Throwable)e);
                }
            }
            return false;
        }
        return true;
    }

    public void setLoginManager(WebLoginManager<?, ?> loginManager) {
        this.loginManager = loginManager;
    }

    public void setRedirectURL(String redirectURL) {
        this.redirectURL = redirectURL;
    }

    public void setAutoRedirect(boolean autoRedirect) {
        this.autoRedirect = autoRedirect;
    }

    public void setFacotry(WebAuthorityFacotry facotry) {
        this.facotry = facotry;
    }
}

