/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.authorities.web;

import cn.featherfly.authorities.AuthenticatedChecker;
import cn.featherfly.authorities.AuthorityException;
import cn.featherfly.authorities.web.AbstractChecker;
import cn.featherfly.authorities.web.WebEnv;
import cn.featherfly.authorities.web.login.WebLoginInfo;
import cn.featherfly.authorities.web.login.WebLoginManager;
import cn.featherfly.common.lang.LogUtils;
import cn.featherfly.common.locale.ResourceBundleUtils;
import cn.featherfly.web.spring.servlet.view.Result;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;

public class WebAuthenticatedChecker
extends AbstractChecker
implements AuthenticatedChecker<WebEnv> {
    private WebLoginManager<?, ?> loginManager;
    private String authenticateURL = "/";

    @Override
    protected boolean doCheck(HttpServletRequest request, HttpServletResponse response, String uri) {
        Result result = new Result();
        result.setStatus(Integer.valueOf(0));
        boolean authenticated = true;
        if (!this.loginManager.isLogin(request)) {
            try {
                result.setMessage(ResourceBundleUtils.getString(AuthorityException.class, (String)"session.invalidation"));
            }
            catch (Exception e) {
                LogUtils.error((Exception)e, (Logger)this.logger);
            }
            authenticated = false;
        } else if (!((WebLoginInfo)this.loginManager.getLoginInfo(request)).getActor().isAvailable()) {
            try {
                result.setMessage(ResourceBundleUtils.getString(AuthorityException.class, (String)"user.available"));
            }
            catch (Exception e) {
                LogUtils.error((Exception)e, (Logger)this.logger);
            }
            authenticated = false;
        }
        if (!authenticated) {
            request.getSession().invalidate();
            response.setHeader("WWW-Authenticate", this.authenticateURL);
            if (request.getHeader("Accept").contains("application/json")) {
                response.setStatus(401);
                this.render(response, result);
            } else {
                try {
                    response.sendError(401, result.getMessage());
                }
                catch (IOException e) {
                    throw new AuthorityException((Throwable)e);
                }
            }
        }
        return authenticated;
    }

    public void setLoginManager(WebLoginManager<?, ?> loginManager) {
        this.loginManager = loginManager;
    }

    public void setAuthenticateURL(String authenticateURL) {
        this.authenticateURL = authenticateURL;
    }
}

