/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.authorities.web;

import cn.featherfly.authorities.AuthorityChecker;
import cn.featherfly.authorities.AuthorityException;
import cn.featherfly.authorities.web.WebEnv;
import cn.featherfly.web.servlet.ServletUtils;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.AntPathMatcher;

public abstract class AbstractChecker
implements AuthorityChecker<WebEnv> {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    private ObjectMapper objectMapper = new ObjectMapper();
    private AntPathMatcher antPathMatcher = new AntPathMatcher();
    protected String charset = "UTF-8";
    protected Collection<String> excludes = new HashSet<String>();

    public boolean check(WebEnv env) {
        HttpServletRequest request = env.getRequest();
        HttpServletResponse response = env.getResponse();
        String uri = ServletUtils.getRequestURI((HttpServletRequest)request);
        this.logger.debug("uri -> {}", (Object)uri);
        boolean exclude = false;
        for (String excludeUri : this.excludes) {
            if (!this.antPathMatcher.match(excludeUri, uri)) continue;
            exclude = true;
            break;
        }
        if (!exclude) {
            return this.doCheck(request, response, uri);
        }
        return true;
    }

    protected void render(HttpServletResponse response, Object result) {
        try {
            response.setContentType("application/json;charset=" + this.charset);
            response.setCharacterEncoding(this.charset);
            this.objectMapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY).writerFor(result.getClass()).writeValue((OutputStream)response.getOutputStream(), result);
        }
        catch (IOException e) {
            throw new AuthorityException((Throwable)e);
        }
    }

    protected abstract boolean doCheck(HttpServletRequest var1, HttpServletResponse var2, String var3);

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public Collection<String> getExcludes() {
        return this.excludes;
    }

    public void setExcludes(Collection<String> excludes) {
        this.excludes = excludes;
    }
}

