/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.authorities;

import cn.featherfly.authorities.Actor;
import cn.featherfly.authorities.Authority;
import cn.featherfly.authorities.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleActor
implements Actor {
    private String id;
    private String name;
    private String descp;
    private boolean available;
    private Actor.ActorType type;
    private Map<String, Authority> ownAuthorityMap = new HashMap<String, Authority>();
    private Map<String, Authority> readableAuthorityMap = new HashMap<String, Authority>();
    private Map<String, Authority> authorizableAuthorityMap = new HashMap<String, Authority>();
    private Map<String, Role> roleMap = new HashMap<String, Role>();

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescp() {
        return this.descp;
    }

    public void setDescp(String descp) {
        this.descp = descp;
    }

    @Override
    public Actor.ActorType getType() {
        return this.type;
    }

    public void setType(Actor.ActorType type) {
        this.type = type;
    }

    @Override
    public boolean isAvailable() {
        return this.available;
    }

    public void setAvailable(boolean available) {
        this.available = available;
    }

    @Override
    public boolean hasAuthority(Authority authority) {
        return this.ownAuthorityMap.containsKey(authority.getCode());
    }

    @Override
    public List<Authority> getOwnAuthoritys() {
        return new ArrayList<Authority>(this.ownAuthorityMap.values());
    }

    public SimpleActor addOwnAuthority(Authority authority) {
        this.ownAuthorityMap.put(authority.getCode(), authority);
        return this;
    }

    public SimpleActor addOwnAuthority(Authority ... authoritys) {
        for (Authority authority : authoritys) {
            this.ownAuthorityMap.put(authority.getCode(), authority);
        }
        return this;
    }

    public SimpleActor addOwnAuthority(Collection<Authority> authoritys) {
        for (Authority authority : authoritys) {
            this.ownAuthorityMap.put(authority.getCode(), authority);
        }
        return this;
    }

    @Override
    public List<Authority> getReadbleAuthoritys() {
        return new ArrayList<Authority>(this.readableAuthorityMap.values());
    }

    public SimpleActor addReadbleAuthority(Authority authority) {
        this.readableAuthorityMap.put(authority.getCode(), authority);
        return this;
    }

    public SimpleActor addReadbleAuthority(Authority ... authoritys) {
        for (Authority authority : authoritys) {
            this.readableAuthorityMap.put(authority.getCode(), authority);
        }
        return this;
    }

    public SimpleActor addReadbleAuthority(Collection<Authority> authoritys) {
        for (Authority authority : authoritys) {
            this.readableAuthorityMap.put(authority.getCode(), authority);
        }
        return this;
    }

    @Override
    public List<Authority> getAuthorizableAuthoritys() {
        return new ArrayList<Authority>(this.authorizableAuthorityMap.values());
    }

    public SimpleActor addAuthorizableAuthority(Authority authority) {
        this.authorizableAuthorityMap.put(authority.getCode(), authority);
        return this;
    }

    public SimpleActor addAuthorizableAuthority(Authority ... authoritys) {
        for (Authority authority : authoritys) {
            this.authorizableAuthorityMap.put(authority.getCode(), authority);
        }
        return this;
    }

    public SimpleActor addAuthorizableAuthority(Collection<Authority> authoritys) {
        for (Authority authority : authoritys) {
            this.authorizableAuthorityMap.put(authority.getCode(), authority);
        }
        return this;
    }

    @Override
    public boolean hasRole(Role role) {
        return this.roleMap.containsKey(role.getCode());
    }

    @Override
    public List<Role> getRoles() {
        return new ArrayList<Role>(this.roleMap.values());
    }

    public SimpleActor addRole(Role role) {
        this.roleMap.put(role.getCode(), role);
        return this;
    }

    public SimpleActor addRole(Role ... roles) {
        for (Role role : roles) {
            this.roleMap.put(role.getCode(), role);
        }
        return this;
    }

    public SimpleActor addRole(Collection<Role> roles) {
        for (Role role : roles) {
            this.roleMap.put(role.getCode(), role);
        }
        return this;
    }
}

