/*
 * Decompiled with CFR 0.152.
 */
package cn.featherfly.authorities;

import cn.featherfly.authorities.Actor;
import cn.featherfly.authorities.Authority;
import cn.featherfly.authorities.Role;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SimpleRole
implements Role {
    private String code;
    private String name;
    private String descp;
    private Map<String, Authority> ownAuthorityMap = new HashMap<String, Authority>();
    private Map<String, Authority> readableAuthorityMap = new HashMap<String, Authority>();
    private Map<String, Authority> authorizableAuthorityMap = new HashMap<String, Authority>();
    private Map<String, Actor> actorMap = new HashMap<String, Actor>();

    @Override
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getDescp() {
        return this.descp;
    }

    public void setDescp(String descp) {
        this.descp = descp;
    }

    @Override
    public boolean hasAuthority(Authority authority) {
        return this.ownAuthorityMap.containsKey(authority.getCode());
    }

    @Override
    public List<Authority> getOwnAuthoritys() {
        return new ArrayList<Authority>(this.ownAuthorityMap.values());
    }

    public SimpleRole addOwnAuthority(Authority authority) {
        this.ownAuthorityMap.put(authority.getCode(), authority);
        return this;
    }

    public SimpleRole addOwnAuthority(Authority ... authoritys) {
        for (Authority authority : authoritys) {
            this.ownAuthorityMap.put(authority.getCode(), authority);
        }
        return this;
    }

    public SimpleRole addOwnAuthority(Collection<Authority> authoritys) {
        for (Authority authority : authoritys) {
            this.ownAuthorityMap.put(authority.getCode(), authority);
        }
        return this;
    }

    @Override
    public List<Authority> getReadbleAuthoritys() {
        return new ArrayList<Authority>(this.readableAuthorityMap.values());
    }

    public SimpleRole addReadbleAuthority(Authority authority) {
        this.readableAuthorityMap.put(authority.getCode(), authority);
        return this;
    }

    public SimpleRole addReadbleAuthority(Authority ... authoritys) {
        for (Authority authority : authoritys) {
            this.readableAuthorityMap.put(authority.getCode(), authority);
        }
        return this;
    }

    public SimpleRole addReadbleAuthority(Collection<Authority> authoritys) {
        for (Authority authority : authoritys) {
            this.readableAuthorityMap.put(authority.getCode(), authority);
        }
        return this;
    }

    @Override
    public List<Authority> getAuthorizableAuthoritys() {
        return new ArrayList<Authority>(this.authorizableAuthorityMap.values());
    }

    public SimpleRole addAuthorizableAuthority(Authority authority) {
        this.authorizableAuthorityMap.put(authority.getCode(), authority);
        return this;
    }

    public SimpleRole addAuthorizableAuthority(Authority ... authoritys) {
        for (Authority authority : authoritys) {
            this.authorizableAuthorityMap.put(authority.getCode(), authority);
        }
        return this;
    }

    public SimpleRole addAuthorizableAuthority(Collection<Authority> authoritys) {
        for (Authority authority : authoritys) {
            this.authorizableAuthorityMap.put(authority.getCode(), authority);
        }
        return this;
    }

    @Override
    public List<Actor> getActors() {
        return new ArrayList<Actor>(this.actorMap.values());
    }

    public SimpleRole addActor(Actor actor) {
        this.actorMap.put(actor.getId(), actor);
        return this;
    }

    public SimpleRole addActor(Actor ... actors) {
        for (Actor actor : actors) {
            this.actorMap.put(actor.getId(), actor);
        }
        return this;
    }

    public SimpleRole addActor(Collection<Actor> actors) {
        for (Actor actor : actors) {
            this.actorMap.put(actor.getId(), actor);
        }
        return this;
    }
}

