/*
 * Decompiled with CFR 0.152.
 */
package cn.fastword.word;

import cn.fastword.word.AbstractIBasicWord;
import cn.fastword.word.beans.TableBeans;
import cn.fastword.word.enums.Document;
import cn.fastword.word.handller.DefaultAnnotationTableHandler;
import cn.fastword.word.handller.DefaultTableBeansHandler;
import cn.fastword.word.handller.ITableBeans;
import cn.hutool.core.io.FileUtil;
import cn.hutool.poi.word.PicType;
import cn.hutool.poi.word.Word07Writer;
import java.awt.Font;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;

public class WordFile07Writer
extends AbstractIBasicWord {
    private final Word07Writer writer = new Word07Writer();

    @Override
    public void addHeader(String title, String ... headers) {
        this.writer.addText(ParagraphAlignment.CENTER, this.defaultHeaderFont, new String[]{title});
        if (headers.length > 0) {
            this.addParagraphRows(ParagraphAlignment.RIGHT, this.defaultFont, headers);
        }
        List paragraphs = this.writer.getDoc().getParagraphs();
        XWPFParagraph paragraph = (XWPFParagraph)paragraphs.get(0);
        paragraph.removeRun(0);
        XWPFRun xwpfRun = paragraph.createRun();
        xwpfRun.setText(title);
        xwpfRun.setColor("CE0000");
        xwpfRun.setFontSize(this.defaultHeaderFont.getSize());
        xwpfRun.setBold(this.defaultHeaderFont.isBold());
        xwpfRun.setFontFamily(this.defaultHeaderFont.getFamily());
        paragraph.addRun(xwpfRun);
        this.addBlankRow();
    }

    @Override
    public void addParagraphRows(ParagraphAlignment alignment, Font defaultFont, String ... texts) {
        this.defaultFont = defaultFont;
        for (String paragraph : texts) {
            this.writer.addText(alignment, this.defaultFont, new String[]{paragraph});
        }
    }

    @Override
    public void addParagraphRows(String ... text) {
        this.addParagraphRows(ParagraphAlignment.LEFT, this.defaultFont, text);
        this.addBlankRow();
    }

    @Override
    public void addParagraphPictureRows(File picture, String ... texts) {
        this.addParagraphRows(ParagraphAlignment.LEFT, this.defaultFont, texts);
        this.addPicture(picture);
        this.addBlankRow();
    }

    @Override
    public void addPicture(File picture) {
        try {
            this.writer.addPicture(picture, this.defaultWidth, this.defaultHeight);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addPicture(InputStream stream, String fileName) {
        try {
            this.writer.addPicture(stream, PicType.PNG, fileName, this.defaultWidth, this.defaultHeight);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addPicture(File picture, int defaultWidth, int defaultHeight) {
        this.defaultHeight = defaultHeight;
        this.defaultWidth = defaultWidth;
        this.addPicture(picture);
    }

    @Override
    public void addBlankRow() {
        this.writer.addText(ParagraphAlignment.LEFT, this.defaultFont, new String[]{""});
    }

    @Override
    public void addTable(ITableBeans handler) {
        try {
            this.writer.addTable(handler.createTable());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void addTable(TableBeans tableBeans) {
        try {
            this.addTable(new DefaultTableBeansHandler(tableBeans));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void addParagraphTableRows(TableBeans tableBeans, String ... texts) {
        try {
            this.addParagraphTableRows(new DefaultTableBeansHandler(tableBeans), texts);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void addParagraphTableRows(List<?> beans, Class<?> beanCls, String ... texts) {
        try {
            this.addParagraphTableRows(new DefaultAnnotationTableHandler(beans, beanCls), texts);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addParagraphTableRows(ITableBeans handler, String ... texts) {
        this.addParagraphRows(ParagraphAlignment.LEFT, this.defaultFont, texts);
        this.addTable(handler);
        this.addBlankRow();
    }

    @Override
    public String getDocumentFile(String fileName, String savePath) {
        String file = this.getDocumentFile(fileName, savePath, Document.WORD);
        try {
            this.writer.flush(FileUtil.file((String)file));
            this.writer.close();
            this.logger.info("==> Preparing: {}", (Object)file);
        }
        catch (Exception e) {
            e.fillInStackTrace();
        }
        return file;
    }
}

