/*
 * Decompiled with CFR 0.152.
 */
package cn.fastposter.cloud.client;

import cn.fastposter.cloud.client.GetPosterArgs;
import cn.fastposter.cloud.client.Poster;
import cn.fastposter.cloud.client.PosterType;
import cn.fastposter.cloud.client.utils.Base64Utils;
import cn.fastposter.cloud.client.utils.DigestUtils;
import cn.fastposter.cloud.client.utils.JsonUtils;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class FastposterCloudClient {
    private static final String CLIENT_TYPE = "java";
    private static final String CLIENT_VERSION = "1.0.0";
    private static final String USER_AGENT = "fastposter-cloud-client/java:1.0.0";
    private final SimpleDateFormat SDF = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private OkHttpClient okHttpClient;
    private String endpoint;
    private String appKey;
    private String appSecret;
    private boolean debug;
    private boolean trace;

    public Poster buildPoster(Integer id, Map<String, String> params) {
        return this.buildPoster(id, params, null);
    }

    public Poster buildPoster(Integer id, Map<String, String> params, PosterType type) {
        return this.buildPoster(id, params, type, false);
    }

    public Poster buildPoster(Integer id, Map<String, String> params, PosterType type, double scale) {
        return this.buildPoster(id, params, type, scale, false);
    }

    public Poster buildPoster(Integer id, Map<String, String> params, PosterType type, boolean b64) {
        return this.buildPoster(id, params, type, 1.0, b64);
    }

    public Poster buildPoster(Integer id, Map<String, String> params, PosterType type, double scale, boolean b64) {
        long time = System.currentTimeMillis();
        String data = JsonUtils.toJson(params);
        String playload = Base64Utils.encodeToUrlSafeString(data.getBytes());
        String sign = DigestUtils.md5DigestAsHex((playload + this.appSecret).getBytes());
        GetPosterArgs.GetPosterArgsBuilder build = GetPosterArgs.builder().id(id).b64(b64).scale(scale).appKey(this.appKey).sign(sign).payload(playload);
        if (type != null) {
            build.type(type.value);
        }
        GetPosterArgs args = build.build();
        String url = this.endpoint + "/v1/build/poster";
        MediaType mediaType = MediaType.parse((String)"application/json");
        String json = JsonUtils.toJson(args);
        if (this.debug) {
            System.out.println(this.SDF.format(new Date()) + " build poster request=" + json);
        }
        RequestBody body = RequestBody.create((String)json, (MediaType)mediaType);
        Request request = new Request.Builder().url(url).post(body).addHeader("User-Agent", USER_AGENT).addHeader("Client-Type", CLIENT_TYPE).addHeader("Client-Version", CLIENT_VERSION).addHeader("Content-Type", "application/json").addHeader("cache-control", "no-cache").build();
        Response response = this.okHttpClient().newCall(request).execute();
        if (this.trace) {
            response.headers().forEach(a -> System.out.println((String)a.getFirst() + ":" + (String)a.getSecond()));
        }
        if (response.code() != 200) {
            System.err.println("code=" + response.code());
            throw new RuntimeException("build poster error!\n" + response.body().string());
        }
        String contentType = response.header("content-type");
        if ("application/json".equals(contentType)) {
            assert (response.body() != null);
            PosterResponse pr = JsonUtils.parseObject(response.body().bytes(), PosterResponse.class);
            if (pr.code != 0) {
                throw new RuntimeException("build poster error!\n" + pr.getMsg());
            }
            return null;
        }
        assert (response.body() != null);
        byte[] bytes = response.body().bytes();
        String traceId = response.header("fastposter-cloud-traceid");
        long size = bytes.length;
        if (type == null) {
            String rcontentType = response.header("Content-Type");
            type = rcontentType != null && contentType != "" ? (rcontentType.contains("jpeg") ? PosterType.jpeg : (rcontentType.contains("pdf") ? PosterType.pdf : (rcontentType.contains("png") ? PosterType.png : (rcontentType.contains("jpg") ? PosterType.jpg : PosterType.jpg)))) : PosterType.jpg;
        }
        if (this.debug) {
            time = System.currentTimeMillis() - time;
            System.out.println(this.SDF.format(new Date()) + " build poster completed. traceId=" + traceId + " id=" + id + " type=" + (Object)((Object)type) + " " + (type.value.length() <= 3 ? " " : "") + "size=" + size + " rt=" + time + "ms" + (b64 ? " b64=" + b64 : "") + (scale != 1.0 ? " scale=" + scale : ""));
        }
        return new Poster(traceId, type, bytes);
    }

    private OkHttpClient okHttpClient() {
        if (this.okHttpClient == null) {
            this.okHttpClient = new OkHttpClient.Builder().connectTimeout(6L, TimeUnit.SECONDS).build();
        }
        return this.okHttpClient;
    }

    FastposterCloudClient(OkHttpClient okHttpClient, String endpoint, String appKey, String appSecret, boolean debug, boolean trace) {
        this.okHttpClient = okHttpClient;
        this.endpoint = endpoint;
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.debug = debug;
        this.trace = trace;
    }

    public static FastposterCloudClientBuilder builder() {
        return new FastposterCloudClientBuilder();
    }

    public static class FastposterCloudClientBuilder {
        private OkHttpClient okHttpClient;
        private String endpoint;
        private String appKey;
        private String appSecret;
        private boolean debug;
        private boolean trace;

        FastposterCloudClientBuilder() {
        }

        public FastposterCloudClientBuilder okHttpClient(OkHttpClient okHttpClient) {
            this.okHttpClient = okHttpClient;
            return this;
        }

        public FastposterCloudClientBuilder endpoint(String endpoint) {
            this.endpoint = endpoint;
            return this;
        }

        public FastposterCloudClientBuilder appKey(String appKey) {
            this.appKey = appKey;
            return this;
        }

        public FastposterCloudClientBuilder appSecret(String appSecret) {
            this.appSecret = appSecret;
            return this;
        }

        public FastposterCloudClientBuilder debug(boolean debug) {
            this.debug = debug;
            return this;
        }

        public FastposterCloudClientBuilder trace(boolean trace) {
            this.trace = trace;
            return this;
        }

        public FastposterCloudClient build() {
            return new FastposterCloudClient(this.okHttpClient, this.endpoint, this.appKey, this.appSecret, this.debug, this.trace);
        }

        public String toString() {
            return "FastposterCloudClient.FastposterCloudClientBuilder(okHttpClient=" + this.okHttpClient + ", endpoint=" + this.endpoint + ", appKey=" + this.appKey + ", appSecret=" + this.appSecret + ", debug=" + this.debug + ", trace=" + this.trace + ")";
        }
    }

    static class PosterResponse {
        int code;
        String msg;
        Object data;
        String traceId;

        public int getCode() {
            return this.code;
        }

        public String getMsg() {
            return this.msg;
        }

        public Object getData() {
            return this.data;
        }

        public String getTraceId() {
            return this.traceId;
        }

        public void setCode(int code) {
            this.code = code;
        }

        public void setMsg(String msg) {
            this.msg = msg;
        }

        public void setData(Object data) {
            this.data = data;
        }

        public void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PosterResponse)) {
                return false;
            }
            PosterResponse other = (PosterResponse)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCode() != other.getCode()) {
                return false;
            }
            String this$msg = this.getMsg();
            String other$msg = other.getMsg();
            if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
                return false;
            }
            Object this$data = this.getData();
            Object other$data = other.getData();
            if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
                return false;
            }
            String this$traceId = this.getTraceId();
            String other$traceId = other.getTraceId();
            return !(this$traceId == null ? other$traceId != null : !this$traceId.equals(other$traceId));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PosterResponse;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCode();
            String $msg = this.getMsg();
            result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
            Object $data = this.getData();
            result = result * 59 + ($data == null ? 43 : $data.hashCode());
            String $traceId = this.getTraceId();
            result = result * 59 + ($traceId == null ? 43 : $traceId.hashCode());
            return result;
        }

        public String toString() {
            return "FastposterCloudClient.PosterResponse(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ", traceId=" + this.getTraceId() + ")";
        }
    }
}

