/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.jdbc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface RoutingStrategy<SEED> {
    @Nullable
    public String getKey(@Nonnull SEED var1);

    public static class MultiTenant
    implements RoutingStrategy<String> {
        private final String format;

        public MultiTenant(String format) {
            this.format = format;
        }

        @Override
        @Nullable
        public String getKey(@Nonnull String tenant) {
            return String.format(this.format, tenant);
        }
    }

    public static class ShardingByMod<SEED extends Number>
    implements RoutingStrategy<SEED> {
        private final String format;
        private final int num;

        public ShardingByMod(String format, int num) {
            this.format = format;
            this.num = num;
        }

        @Override
        @Nullable
        public String getKey(@Nonnull SEED seed) {
            int index = ((Number)seed).intValue() % this.num;
            return String.format(this.format, index);
        }
    }
}

