/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.jdbc;

import cn.fantasticmao.mundo.data.jdbc.RoutingSeed;
import cn.fantasticmao.mundo.data.jdbc.RoutingSeedContext;
import cn.fantasticmao.mundo.data.jdbc.RoutingSeedExtractor;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class RoutingRepositoryProxyPostProcessor
implements RepositoryProxyPostProcessor {
    public void postProcess(@Nonnull ProxyFactory factory, @Nonnull RepositoryInformation repositoryInformation) {
        int i;
        Advisor[] advisors = factory.getAdvisors();
        for (i = advisors.length - 1; i > 0 && !(advisors[i].getAdvice() instanceof TransactionInterceptor); --i) {
        }
        factory.addAdvice(i, (Advice)new RoutingMethodInterceptor(repositoryInformation));
    }

    private static class RoutingMethodInterceptor
    implements MethodInterceptor {
        private final RepositoryInformation repositoryInformation;

        public RoutingMethodInterceptor(RepositoryInformation repositoryInformation) {
            this.repositoryInformation = repositoryInformation;
        }

        @Nullable
        public Object invoke(@Nonnull MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object[] arguments = invocation.getArguments();
            Object seedObj = RoutingSeedExtractor.fromDomainFields(arguments, this.repositoryInformation.getDomainType());
            if (seedObj != null) {
                return this.invokeWithSeed(invocation, seedObj);
            }
            seedObj = RoutingSeedExtractor.fromMethodArguments(arguments, method.getParameterAnnotations());
            if (seedObj != null) {
                return this.invokeWithSeed(invocation, seedObj);
            }
            RoutingSeed seedAnnotation = RoutingSeedExtractor.fromMethodDeclaration(method);
            if (seedAnnotation != null) {
                return this.invokeWithSeed(invocation, seedAnnotation);
            }
            seedAnnotation = RoutingSeedExtractor.fromClassDeclaration(method.getDeclaringClass());
            if (seedAnnotation != null) {
                return this.invokeWithSeed(invocation, seedAnnotation);
            }
            return invocation.proceed();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Object invokeWithSeed(@Nonnull MethodInvocation invocation, @Nonnull Object seed) throws Throwable {
            try {
                RoutingSeedContext.set(seed);
                Object object = invocation.proceed();
                return object;
            }
            finally {
                RoutingSeedContext.remove();
            }
        }
    }
}

