/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.support;

public interface IdGenerator {
    public long next();

    public static class Snowflake
    implements IdGenerator {
        private static final int BIT_TIMESTAMP = 41;
        private static final int BIT_WORKER_NUMBER = 10;
        private static final int BIT_SEQUENCE_NUMBER = 12;
        protected static final int LEFT_SEQUENCE_NUMBER = 0;
        protected static final int LEFT_WORKER_NUMBER = 12;
        protected static final int LEFT_TIMESTAMP = 22;
        protected static final long MAX_TIMESTAMP = 0x1FFFFFFFFFFL;
        protected static final long MAX_WORKER_NUMBER = 1023L;
        protected static final long MAX_SEQUENCE_NUMBER = 4095L;
        private static final long START_TIMESTAMP = 1577808000000L;
        private final long workerNumber;
        private long lastTimestamp;
        private long sequence;

        protected Snowflake(long workerNumber) {
            this.workerNumber = workerNumber;
            this.lastTimestamp = 0L;
            this.sequence = 0L;
        }

        public static IdGenerator newInstance(long workerNumber) {
            if (workerNumber < 0L || workerNumber > 1023L) {
                throw new IllegalArgumentException("Invalid worker number: " + workerNumber);
            }
            return new Snowflake(workerNumber);
        }

        protected static long getTimestamp(long id) {
            return ((id & 0x7FFFFFFFFFC00000L) >>> 22) + 1577808000000L;
        }

        protected static long getWorkerNumber(long id) {
            return (id & 0x3FF000L) >>> 12;
        }

        protected static long getSequence(long id) {
            return id & 0xFFFL;
        }

        @Override
        public synchronized long next() {
            long timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                String message = String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp);
                throw new IllegalArgumentException(message);
            }
            if (this.lastTimestamp == timestamp) {
                this.sequence = this.sequence + 1L & 0xFFFL;
                if (this.sequence == 0L) {
                    timestamp = this.tilNextMillis(this.lastTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = timestamp;
            return timestamp - 1577808000000L << 22 | this.workerNumber << 12 | this.sequence << 0;
        }

        protected long timeGen() {
            return System.currentTimeMillis();
        }

        private long tilNextMillis(long lastTimestamp) {
            long timestamp = this.timeGen();
            while (timestamp <= lastTimestamp) {
                timestamp = this.timeGen();
            }
            return timestamp;
        }
    }
}

