/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.jdbc;

import cn.fantasticmao.mundo.data.jdbc.RoutingSeedContext;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.springframework.lang.Nullable;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class RoutingTransactionTemplate {
    private final TransactionTemplate delegate;

    public RoutingTransactionTemplate(TransactionTemplate transactionTemplate) {
        this.delegate = transactionTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T execute(@Nonnull Object seed, TransactionCallback<T> action) throws TransactionException {
        RoutingSeedContext.set(seed);
        try {
            Object object = this.delegate.execute(action);
            return (T)object;
        }
        finally {
            RoutingSeedContext.remove();
        }
    }

    public void executeWithoutResult(@Nonnull Object seed, Consumer<TransactionStatus> action) throws TransactionException {
        RoutingSeedContext.set(seed);
        try {
            this.delegate.executeWithoutResult(action);
        }
        finally {
            RoutingSeedContext.remove();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoutingTransactionTemplate)) {
            return false;
        }
        RoutingTransactionTemplate that = (RoutingTransactionTemplate)o;
        return Objects.equals(this.delegate, that.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return "RoutingTransactionTemplate{delegate=" + this.delegate + "}";
    }
}

