/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.jdbc;

import cn.fantasticmao.mundo.data.jdbc.RoutingSeedContext;
import cn.fantasticmao.mundo.data.jdbc.RoutingStrategy;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class RoutingDataSource<SEED>
extends AbstractRoutingDataSource {
    private final RoutingStrategy<SEED> routingStrategy;
    private final Class<SEED> seedClass;

    public RoutingDataSource(@Nonnull Map<Object, DataSource> dataSources, RoutingStrategy<SEED> routingStrategy, Class<SEED> seedClass) {
        this(dataSources, null, routingStrategy, seedClass);
    }

    public RoutingDataSource(@Nonnull Map<Object, DataSource> dataSources, @Nullable DataSource defaultDataSource, RoutingStrategy<SEED> routingStrategy, Class<SEED> seedClass) {
        Map<Object, Object> targetDataSources = dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        super.setTargetDataSources(targetDataSources);
        if (defaultDataSource != null) {
            super.setDefaultTargetDataSource((Object)defaultDataSource);
        }
        this.routingStrategy = routingStrategy;
        this.seedClass = seedClass;
    }

    @Nullable
    protected Object determineCurrentLookupKey() {
        SEED seed = RoutingSeedContext.get(this.seedClass);
        return seed != null ? this.routingStrategy.getKey(seed) : null;
    }
}

