/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.jdbc;

import cn.fantasticmao.mundo.data.jdbc.RoutingSeed;
import cn.fantasticmao.mundo.data.jdbc.RoutingSeedContext;
import cn.fantasticmao.mundo.data.jdbc.RoutingSeedExtractor;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.Advisor;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;
import org.springframework.transaction.interceptor.TransactionInterceptor;

public class RoutingRepositoryProxyPostProcessor
implements RepositoryProxyPostProcessor {
    public void postProcess(@Nonnull ProxyFactory factory, @Nonnull RepositoryInformation repositoryInformation) {
        int i;
        Advisor[] advisors = factory.getAdvisors();
        for (i = advisors.length - 1; i > 0 && !(advisors[i].getAdvice() instanceof TransactionInterceptor); --i) {
        }
        factory.addAdvice(i, (Advice)new RoutingMethodInterceptor(repositoryInformation));
    }

    private static class RoutingMethodInterceptor
    implements MethodInterceptor {
        private final RepositoryInformation repositoryInformation;

        public RoutingMethodInterceptor(RepositoryInformation repositoryInformation) {
            this.repositoryInformation = repositoryInformation;
        }

        @Nullable
        public Object invoke(@Nonnull MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Object[] arguments = invocation.getArguments();
            Object seedObj = RoutingSeedExtractor.fromDomainFields(arguments, this.repositoryInformation.getDomainType());
            if (seedObj != null) {
                RoutingSeedContext.set(seedObj);
                return invocation.proceed();
            }
            seedObj = RoutingSeedExtractor.fromMethodArguments(arguments, method.getParameterAnnotations());
            if (seedObj != null) {
                RoutingSeedContext.set(seedObj);
                return invocation.proceed();
            }
            RoutingSeed seedAnnotation = RoutingSeedExtractor.fromMethodDeclaration(method);
            if (seedAnnotation != null) {
                RoutingSeedContext.set(seedAnnotation);
                return invocation.proceed();
            }
            seedAnnotation = RoutingSeedExtractor.fromClassDeclaration(method.getDeclaringClass());
            if (seedAnnotation != null) {
                RoutingSeedContext.set(seedAnnotation);
                return invocation.proceed();
            }
            return invocation.proceed();
        }
    }
}

