/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.jdbc;

import cn.fantasticmao.mundo.data.jdbc.RoutingSeedContext;
import cn.fantasticmao.mundo.data.jdbc.RoutingStrategy;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class RoutingDataSource<SEED>
extends AbstractRoutingDataSource {
    private final RoutingStrategy<SEED> routingStrategy;
    private final Class<SEED> seedClass;

    public RoutingDataSource(@Nonnull Map<Object, Object> dataSources, @Nonnull DataSource defaultDataSource, RoutingStrategy<SEED> routingStrategy, Class<SEED> seedClass) {
        super.setTargetDataSources(dataSources);
        super.setDefaultTargetDataSource((Object)defaultDataSource);
        this.routingStrategy = routingStrategy;
        this.seedClass = seedClass;
    }

    @Nullable
    protected Object determineCurrentLookupKey() {
        SEED seed;
        try {
            seed = RoutingSeedContext.get(this.seedClass);
        }
        finally {
            RoutingSeedContext.remove();
        }
        if (seed == null) {
            return null;
        }
        return this.routingStrategy.getKey(seed);
    }
}

