/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.partition;

import cn.fantasticmao.mundo.data.partition.PartitionParam;
import cn.fantasticmao.mundo.data.partition.PartitionSeedContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.support.RepositoryProxyPostProcessor;

public class PartitionDataSourcePostProcessor
implements RepositoryProxyPostProcessor {
    public void postProcess(@Nonnull ProxyFactory factory, @Nonnull RepositoryInformation repositoryInformation) {
        factory.addAdvice((Advice)PartitionMethodInterceptor.INSTANCE);
    }

    static enum PartitionMethodInterceptor implements MethodInterceptor
    {
        INSTANCE;

        private final Logger LOGGER = LoggerFactory.getLogger(PartitionMethodInterceptor.class);

        public Object invoke(MethodInvocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Annotation[][] annotations = method.getParameterAnnotations();
            int pos = -1;
            block0: for (int i = 0; i < annotations.length; ++i) {
                for (int j = 0; j < annotations[i].length; ++j) {
                    Annotation ann = annotations[i][j];
                    if (!(ann instanceof PartitionParam)) continue;
                    pos = i;
                    break block0;
                }
            }
            if (pos >= 0) {
                Object[] arguments = invocation.getArguments();
                Object partitionSeed = arguments[pos];
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("found @PartitionParam argument \"{}\" at {}", partitionSeed, (Object)method.toString());
                }
                PartitionSeedContext.push(partitionSeed);
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("push partition seed object \"{}\" to PartitionSeedContext", partitionSeed);
                }
            }
            Object result = invocation.proceed();
            if (pos >= 0) {
                PartitionSeedContext.clear();
                if (this.LOGGER.isDebugEnabled()) {
                    this.LOGGER.debug("clear partition seed object from PartitionSeedContext");
                }
            }
            return result;
        }
    }
}

