/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.partition;

import cn.fantasticmao.mundo.data.partition.PartitionSeedContext;
import cn.fantasticmao.mundo.data.partition.PartitionSeedToDataSourceKeyStrategy;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.util.Assert;

public class PartitionDataSource
extends AbstractRoutingDataSource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionDataSource.class);
    private PartitionSeedToDataSourceKeyStrategy partitionSeedToDataSourceKeyStrategy;

    public PartitionDataSource(@Nonnull Map<String, DataSource> dataSources, @Nullable DataSource defaultDataSource, @Nonnull PartitionSeedToDataSourceKeyStrategy partitionSeedToDataSourceKeyStrategy) {
        this.initTargetDataSources(dataSources);
        this.initDefaultTargetDataSource(defaultDataSource);
        this.partitionSeedToDataSourceKeyStrategy = partitionSeedToDataSourceKeyStrategy;
    }

    protected Object determineCurrentLookupKey() {
        Assert.notNull((Object)this.partitionSeedToDataSourceKeyStrategy, (String)"partitionSeedToDataSourceKeyStrategy must not be null");
        Object seedObject = PartitionSeedContext.pop();
        String dataSourceKey = (String)this.partitionSeedToDataSourceKeyStrategy.apply(seedObject);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("use seed \"{}\" to determine the current lookup key \"{}\"", seedObject, (Object)dataSourceKey);
        }
        return dataSourceKey;
    }

    private void initTargetDataSources(Map<String, DataSource> dataSources) {
        if (dataSources != null && !dataSources.isEmpty()) {
            HashMap<String, DataSource> targetDataSources = new HashMap<String, DataSource>(dataSources.size());
            for (Map.Entry<String, DataSource> entry : dataSources.entrySet()) {
                targetDataSources.put(entry.getKey(), entry.getValue());
            }
            super.setTargetDataSources(targetDataSources);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("loading targetDataSources: \"{}\"", targetDataSources);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("loading targetDataSources is null or empty");
        }
    }

    private void initDefaultTargetDataSource(DataSource defaultDataSource) {
        if (defaultDataSource != null) {
            super.setDefaultTargetDataSource((Object)defaultDataSource);
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("loading defaultTargetDataSource: \"{}\"", (Object)defaultDataSource);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("loading defaultTargetDataSource is null");
        }
    }
}

