/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.support;

import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.exception.MemcachedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemcacheClientUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(MemcacheClientUtil.class);
    private MemcachedClient memcachedClient;

    public MemcacheClientUtil(MemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
    }

    public <T> T get(String key) {
        try {
            return (T)this.memcachedClient.get(key);
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            LOGGER.error("MemcacheClient get key(" + key + ") error!", e);
            return null;
        }
    }

    public boolean add(String key, Object value, int exp) {
        try {
            return this.memcachedClient.add(key, exp, value);
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            LOGGER.error("MemcacheClient add key(" + key + ") error!", e);
            return false;
        }
    }

    public boolean replace(String key, Object value, int exp) {
        try {
            return this.memcachedClient.replace(key, exp, value);
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            LOGGER.error("MemcacheClient replace key(" + key + ") error!", e);
            return false;
        }
    }

    public boolean set(String key, Object value, int exp) {
        try {
            return this.memcachedClient.set(key, exp, value);
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            LOGGER.error("MemcacheClient set key(" + key + ") error!", e);
            return false;
        }
    }

    public boolean delete(String key) {
        try {
            return this.memcachedClient.delete(key);
        }
        catch (InterruptedException | TimeoutException | MemcachedException e) {
            LOGGER.error("MemcacheClient delete key(" + key + ") error!", e);
            return false;
        }
    }
}

