/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.support;

import cn.fantasticmao.mundo.data.support.SQLiteDialect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.springframework.data.jdbc.repository.config.DialectResolver;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcOperations;

public class SQLiteDialectProvider
implements DialectResolver.JdbcDialectProvider {
    @Nonnull
    public Optional<Dialect> getDialect(@Nonnull JdbcOperations operations) {
        ConnectionCallback callback = this::getDialect;
        return Optional.ofNullable((Dialect)operations.execute(callback));
    }

    private Dialect getDialect(@Nonnull Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        String name = metaData.getDatabaseProductName().toLowerCase(Locale.ENGLISH);
        return name.contains("sqlite") ? SQLiteDialect.INSTANCE : null;
    }
}

