/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.support;

import cn.fantasticmao.mundo.data.support.SQLiteConverters;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import org.springframework.data.relational.core.dialect.AbstractDialect;
import org.springframework.data.relational.core.dialect.LimitClause;
import org.springframework.data.relational.core.dialect.LockClause;
import org.springframework.data.relational.core.sql.LockOptions;

public class SQLiteDialect
extends AbstractDialect {
    public static final SQLiteDialect INSTANCE = new SQLiteDialect();

    @Nonnull
    public LimitClause limit() {
        return SQLiteLimitClause.INSTANCE;
    }

    @Nonnull
    public LockClause lock() {
        return SQLiteLockClause.INSTANCE;
    }

    @Nonnull
    public Collection<Object> getConverters() {
        return List.of(SQLiteConverters.StringToLocalTime.INSTANCE, SQLiteConverters.StringToLocalDate.INSTANCE, SQLiteConverters.StringToLocalDateTime.INSTANCE, SQLiteConverters.LocalTimeToString.INSTANCE, SQLiteConverters.LocalDateToString.INSTANCE, SQLiteConverters.LocalDateTimeToString.INSTANCE);
    }

    static enum SQLiteLockClause implements LockClause
    {
        INSTANCE;


        @Nonnull
        public String getLock(@Nonnull LockOptions lockOptions) {
            return "";
        }

        @Nonnull
        public LockClause.Position getClausePosition() {
            return LockClause.Position.AFTER_ORDER_BY;
        }
    }

    static enum SQLiteLimitClause implements LimitClause
    {
        INSTANCE;


        @Nonnull
        public String getLimit(long limit) {
            return "LIMIT " + limit;
        }

        @Nonnull
        public String getOffset(long offset) {
            return "OFFSET " + offset;
        }

        @Nonnull
        public String getLimitOffset(long limit, long offset) {
            return String.format("LIMIT %d OFFSET %d", limit, offset);
        }

        @Nonnull
        public LimitClause.Position getClausePosition() {
            return LimitClause.Position.AFTER_ORDER_BY;
        }
    }
}

