/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.support;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import javax.annotation.Nonnull;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;

interface SQLiteConverters {

    @WritingConverter
    public static enum LocalDateTimeToString implements Converter<LocalDateTime, String>
    {
        INSTANCE;

        private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

        public String convert(@Nonnull LocalDateTime source) {
            return this.formatter.format(source);
        }
    }

    @WritingConverter
    public static enum LocalDateToString implements Converter<LocalDate, String>
    {
        INSTANCE;

        private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

        public String convert(@Nonnull LocalDate source) {
            return this.formatter.format(source);
        }
    }

    @WritingConverter
    public static enum LocalTimeToString implements Converter<LocalTime, String>
    {
        INSTANCE;

        private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");

        public String convert(@Nonnull LocalTime source) {
            return this.formatter.format(source);
        }
    }

    @ReadingConverter
    public static enum StringToLocalDateTime implements Converter<String, LocalDateTime>
    {
        INSTANCE;

        private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

        public LocalDateTime convert(@Nonnull String source) {
            return LocalDateTime.parse(source, this.formatter);
        }
    }

    @ReadingConverter
    public static enum StringToLocalDate implements Converter<String, LocalDate>
    {
        INSTANCE;

        private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

        public LocalDate convert(@Nonnull String source) {
            return LocalDate.parse(source, this.formatter);
        }
    }

    @ReadingConverter
    public static enum StringToLocalTime implements Converter<String, LocalTime>
    {
        INSTANCE;

        private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("HH:mm:ss");

        public LocalTime convert(@Nonnull String source) {
            return LocalTime.parse(source, this.formatter);
        }
    }
}

