/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.jdbc;

import cn.fantasticmao.mundo.data.jdbc.RoutingSeed;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.core.annotation.MergedAnnotation;
import org.springframework.core.annotation.MergedAnnotations;
import org.springframework.data.util.ReflectionUtils;

final class RoutingSeedExtractor {
    private static final ConcurrentHashMap<Class<?>, Optional<Field>> DOMAIN_FIELD_CACHE = new ConcurrentHashMap(32);
    private static final ConcurrentHashMap<Class<?>, Method> DOMAIN_GETTER_CACHE = new ConcurrentHashMap(32);
    private static final ConcurrentHashMap<Method, MergedAnnotation<RoutingSeed>> METHOD_ANNOTATION_CACHE = new ConcurrentHashMap(32);
    private static final ConcurrentHashMap<Class<?>, MergedAnnotation<RoutingSeed>> CLASS_ANNOTATION_CACHE = new ConcurrentHashMap(32);

    RoutingSeedExtractor() {
    }

    @Nullable
    public static Object fromDomainFields(Object[] arguments, Class<?> domainType) throws InvocationTargetException, IllegalAccessException {
        Optional<Field> seedFieldOpt = RoutingSeedExtractor.getDomainField(domainType);
        if (seedFieldOpt.isEmpty()) {
            return null;
        }
        int x = -1;
        for (int i = 0; i < arguments.length; ++i) {
            Object argument = arguments[i];
            if (!domainType.isInstance(argument)) continue;
            x = i;
            break;
        }
        return x >= 0 ? RoutingSeedExtractor.getDomainGetter(seedFieldOpt.get(), domainType).invoke(arguments[x], new Object[0]) : null;
    }

    @Nullable
    public static Object fromMethodArguments(Object[] arguments, Annotation[][] annotations) {
        if (arguments.length != annotations.length) {
            return null;
        }
        int x = -1;
        block0: for (int i = 0; i < annotations.length; ++i) {
            for (int j = 0; j < annotations[i].length; ++j) {
                if (!(annotations[i][j] instanceof RoutingSeed)) continue;
                x = i;
                break block0;
            }
        }
        return x >= 0 ? arguments[x] : null;
    }

    @Nullable
    public static RoutingSeed fromMethodDeclaration(Method method) {
        MergedAnnotation mergedAnnotation = METHOD_ANNOTATION_CACHE.computeIfAbsent(method, _method -> MergedAnnotations.from((AnnotatedElement)_method).get(RoutingSeed.class));
        return mergedAnnotation.isPresent() ? (RoutingSeed)mergedAnnotation.synthesize() : null;
    }

    @Nullable
    public static RoutingSeed fromClassDeclaration(Class<?> clazz) {
        MergedAnnotation mergedAnnotation = CLASS_ANNOTATION_CACHE.computeIfAbsent(clazz, _clazz -> MergedAnnotations.from((AnnotatedElement)_clazz).get(RoutingSeed.class));
        return mergedAnnotation.isPresent() ? (RoutingSeed)mergedAnnotation.synthesize() : null;
    }

    private static Optional<Field> getDomainField(Class<?> domainType) {
        return DOMAIN_FIELD_CACHE.computeIfAbsent(domainType, clazz -> {
            Field seedField = ReflectionUtils.findField((Class)clazz, (ReflectionUtils.DescribedFieldFilter)new ReflectionUtils.DescribedFieldFilter(){

                @Nonnull
                public String getDescription() {
                    return "@RoutingSeed must be unique";
                }

                public boolean matches(@Nonnull Field field) {
                    return field.isAnnotationPresent(RoutingSeed.class);
                }
            }, (boolean)true);
            return Optional.ofNullable(seedField);
        });
    }

    private static Method getDomainGetter(@Nonnull Field seedField, Class<?> domainType) {
        return DOMAIN_GETTER_CACHE.computeIfAbsent(domainType, clazz -> {
            try {
                return new PropertyDescriptor(seedField.getName(), (Class<?>)clazz).getReadMethod();
            }
            catch (IntrospectionException e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
        });
    }
}

