/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.jdbc;

import cn.fantasticmao.mundo.data.jdbc.RoutingSeed;
import javax.annotation.Nullable;
import org.springframework.core.NamedThreadLocal;

final class RoutingSeedContext {
    private static final ThreadLocal<Object> CONTEXT = new NamedThreadLocal("Current DataSource Route Seed");

    RoutingSeedContext() {
    }

    public static void set(Object seed) {
        CONTEXT.set(seed);
    }

    @Nullable
    public static <T> T get(Class<T> clazz) throws ClassCastException {
        Object seed = CONTEXT.get();
        if (seed == null) {
            return null;
        }
        if (seed instanceof RoutingSeed) {
            RoutingSeed annotation = (RoutingSeed)seed;
            String value = annotation.value();
            if (Integer.class.isAssignableFrom(clazz)) {
                return (T)Integer.valueOf(value);
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return (T)Long.valueOf(value);
            }
            if (String.class.isAssignableFrom(clazz)) {
                return (T)value;
            }
            throw new ClassCastException("@RoutingSeed currently supports: int, long, string, invalid seed value: " + seed);
        }
        return clazz.cast(seed);
    }

    public static void remove() {
        CONTEXT.remove();
    }
}

