/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.jdbc;

import cn.fantasticmao.mundo.data.jdbc.AbstractConnection;
import cn.fantasticmao.mundo.data.jdbc.RoutingSeedContext;
import cn.fantasticmao.mundo.data.jdbc.RoutingStrategy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import org.springframework.jdbc.datasource.AbstractDataSource;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;

public class RoutingDataSource<SEED>
extends AbstractRoutingDataSource {
    private final RoutingStrategy<SEED> routingStrategy;
    private final Class<SEED> seedClass;

    public RoutingDataSource(@Nonnull Map<Object, DataSource> dataSources, final @Nonnull DatabaseMetaData databaseMetaData, RoutingStrategy<SEED> routingStrategy, Class<SEED> seedClass) {
        this(dataSources, routingStrategy, seedClass);
        AbstractDataSource defaultDataSource = new AbstractDataSource(){
            private final Connection connection = new AbstractConnection(){

                @Override
                public DatabaseMetaData getMetaData() {
                    return databaseMetaData;
                }
            };

            public Connection getConnection() {
                return this.connection;
            }

            public Connection getConnection(String username, String password) {
                return this.connection;
            }
        };
        super.setDefaultTargetDataSource((Object)defaultDataSource);
    }

    public RoutingDataSource(@Nonnull Map<Object, DataSource> dataSources, @Nonnull DataSource defaultDataSource, RoutingStrategy<SEED> routingStrategy, Class<SEED> seedClass) {
        this(dataSources, routingStrategy, seedClass);
        super.setDefaultTargetDataSource((Object)defaultDataSource);
    }

    private RoutingDataSource(@Nonnull Map<Object, DataSource> dataSources, RoutingStrategy<SEED> routingStrategy, Class<SEED> seedClass) {
        Map<Object, Object> targetDataSources = dataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        super.setTargetDataSources(targetDataSources);
        this.routingStrategy = routingStrategy;
        this.seedClass = seedClass;
    }

    @Nullable
    protected Object determineCurrentLookupKey() {
        SEED seed = RoutingSeedContext.get(this.seedClass);
        return seed != null ? this.routingStrategy.getKey(seed) : null;
    }
}

