/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.support;

import java.util.Arrays;
import javax.annotation.concurrent.ThreadSafe;

public interface Snowflake {
    public long nextId();

    @ThreadSafe
    public static class TwitterSnowflake
    implements Snowflake {
        private static final int BIT_NOT_USED = 1;
        private static final int BIT_TIMESTAMP = 41;
        private static final int BIT_WORKER_NUMBER = 10;
        private static final int BIT_SEQUENCE_NUMBER = 12;
        private static final int LEFT_SEQUENCE_NUMBER = 0;
        private static final int LEFT_WORKER_NUMBER = 12;
        private static final int LEFT_TIMESTAMP = 22;
        private static final int RIGHT_TIMESTAMP = 1;
        private static final int RIGHT_WORKER_NUMBER = 42;
        private static final int RIGHT_SEQUENCE_NUMBER = 52;
        private static final long MAX_TIMESTAMP = 0x1FFFFFFFFFFL;
        private static final long MAX_WORKER_NUMBER = 1023L;
        private static final long MAX_SEQUENCE_NUMBER = -4097L;
        private static final long START_TIMESTAMP = 1546272000000L;
        private final long workerNumber;
        private long lastTimestamp;
        private long sequence;

        private TwitterSnowflake(long workerNumber) {
            this.workerNumber = workerNumber;
            this.lastTimestamp = 0L;
            this.sequence = 0L;
        }

        public static Snowflake getInstance(long workerNumber) {
            if (workerNumber < 0L || workerNumber > 1023L) {
                throw new IllegalArgumentException();
            }
            return new TwitterSnowflake(workerNumber);
        }

        public static String toBinaryString(long id) {
            char[] chars = new char[64];
            Arrays.fill(chars, '0');
            String idBinaryString = Long.toBinaryString(id);
            idBinaryString.getChars(0, idBinaryString.length(), chars, 64 - idBinaryString.length());
            String binaryString = new String(chars);
            return String.format("raw id: %s", id) + System.lineSeparator() + String.format("binary string: %s", binaryString) + System.lineSeparator() + String.format("segment string: %s, %s, %s, %s", binaryString.substring(0, 1), binaryString.substring(1, 42), binaryString.substring(42, 52), binaryString.substring(52, 64));
        }

        @Override
        public synchronized long nextId() {
            long timestamp = this.timeGen();
            if (timestamp < this.lastTimestamp) {
                throw new IllegalArgumentException(String.format("Clock moved backwards.  Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
            }
            if (this.lastTimestamp == timestamp) {
                this.sequence = this.sequence + 1L & 0xFFFFFFFFFFFFEFFFL;
                if (this.sequence == 0L) {
                    timestamp = this.tilNextMillis(this.lastTimestamp);
                }
            } else {
                this.sequence = 0L;
            }
            this.lastTimestamp = timestamp;
            return timestamp - 1546272000000L << 22 | this.workerNumber << 12 | this.sequence;
        }

        private long timeGen() {
            return System.currentTimeMillis();
        }

        private long tilNextMillis(long lastTimestamp) {
            long timestamp = this.timeGen();
            while (timestamp <= lastTimestamp) {
                timestamp = this.timeGen();
            }
            return timestamp;
        }
    }
}

