/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.support;

import cn.fantasticmao.mundo.data.support.MemcacheClientUtil;
import com.google.common.cache.AbstractLoadingCache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.CacheStats;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.rubyeye.xmemcached.MemcachedClient;

public class MemcacheLoadingCache<K, V>
extends AbstractLoadingCache<K, V> {
    private final MemcacheClientUtil memcacheClientUtil;
    private final CacheLoader<K, V> cacheLoader;
    private final Function<Object, String> keyGenerator;
    private final int expireAfterWriteSeconds;

    public MemcacheLoadingCache(MemcachedClient memcachedClient, CacheLoader<K, V> cacheLoader, Function<Object, String> keyGenerator) {
        this(memcachedClient, cacheLoader, keyGenerator, Math.toIntExact(TimeUnit.DAYS.toSeconds(30L)));
    }

    public MemcacheLoadingCache(MemcachedClient memcachedClient, CacheLoader<K, V> cacheLoader, Function<Object, String> keyGenerator, int expireAfterWriteSeconds) {
        this.memcacheClientUtil = new MemcacheClientUtil(memcachedClient);
        this.cacheLoader = cacheLoader;
        this.keyGenerator = keyGenerator;
        this.expireAfterWriteSeconds = expireAfterWriteSeconds;
    }

    public synchronized V get(K key) {
        Object val = this.getIfPresent(key);
        if (val == null) {
            try {
                val = this.cacheLoader.load(key);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (val != null) {
                this.put(key, val);
            }
        }
        return val;
    }

    public synchronized V get(K key, Callable<? extends V> valueLoader) {
        V val = this.getIfPresent(key);
        if (val == null) {
            try {
                val = valueLoader.call();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (val != null) {
                this.put(key, val);
            }
        }
        return val;
    }

    public V getIfPresent(Object key) {
        String k = this.keyGenerator.apply(key);
        return (V)this.memcacheClientUtil.get(k);
    }

    public void put(K key, V value) {
        String k = this.keyGenerator.apply(key);
        this.memcacheClientUtil.set(k, value, this.expireAfterWriteSeconds);
    }

    public void invalidate(Object key) {
        String k = this.keyGenerator.apply(key);
        this.memcacheClientUtil.delete(k);
    }

    public synchronized void refresh(K key) {
        Object val = null;
        try {
            val = this.cacheLoader.load(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (val != null) {
            this.put(key, val);
        }
    }

    public CacheStats stats() {
        throw new UnsupportedOperationException();
    }

    public ConcurrentMap<K, V> asMap() {
        throw new UnsupportedOperationException();
    }
}

