/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.support;

import cn.fantasticmao.mundo.data.support.MemcacheLoadingCache;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import net.rubyeye.xmemcached.MemcachedClient;

public class MemcacheCacheBuilder<K, V extends Serializable> {
    private MemcachedClient memcachedClient;
    private Function<Object, String> keyConvert;
    private int expireAfterWriteSeconds;

    private MemcacheCacheBuilder(MemcachedClient memcachedClient) {
        this.memcachedClient = memcachedClient;
        this.keyConvert = String::valueOf;
        this.expireAfterWriteSeconds = Math.toIntExact(TimeUnit.DAYS.toSeconds(30L));
    }

    public static <K, V extends Serializable> MemcacheCacheBuilder<K, V> newBuilder(MemcachedClient memcachedClient) {
        return new MemcacheCacheBuilder<K, V>(memcachedClient);
    }

    public MemcacheCacheBuilder<K, V> keyConvert(Function<Object, String> keyConvert) {
        this.keyConvert = keyConvert;
        return this;
    }

    public MemcacheCacheBuilder<K, V> expireTime(long duration, TimeUnit unit) {
        long time = unit.toSeconds(duration);
        this.expireAfterWriteSeconds = Math.toIntExact(time);
        return this;
    }

    public LoadingCache<K, V> build(CacheLoader<K, V> cacheLoader) {
        return new MemcacheLoadingCache<K, V>(this.memcachedClient, cacheLoader, this.keyConvert, this.expireAfterWriteSeconds);
    }
}

