/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.data.partition;

import cn.fantasticmao.mundo.data.partition.PartitionSeedProvider;
import java.util.function.Function;
import javax.annotation.Nullable;

@FunctionalInterface
public interface PartitionSeedToDataSourceKeyStrategy
extends Function<Object, String> {

    public static class TimeRangeStrategy
    implements PartitionSeedToDataSourceKeyStrategy {
        @Override
        public String apply(Object o) {
            return null;
        }
    }

    public static class NumberModulusStrategy
    implements PartitionSeedToDataSourceKeyStrategy {
        private String formatStr;
        private int dataSourceSize;

        public NumberModulusStrategy(String formatStr, int dataSourceSize) {
            this.formatStr = formatStr;
            this.dataSourceSize = dataSourceSize;
        }

        @Override
        public String apply(@Nullable Object seedObject) {
            if (seedObject == null) {
                return null;
            }
            if (seedObject instanceof PartitionSeedProvider) {
                seedObject = ((PartitionSeedProvider)seedObject).getSeed();
            }
            if (seedObject instanceof Number) {
                Number seedNumber = (Number)seedObject;
                return String.format(this.formatStr, seedNumber.longValue() % (long)this.dataSourceSize + 1L);
            }
            throw new IllegalArgumentException("cannot cast the partition seed object '" + seedObject + "' to 'java.lang.Number'");
        }
    }
}

