/*
 * Decompiled with CFR 0.152.
 */
package cn.fantasticmao.mundo.core.util;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.annotation.Nullable;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public enum CipherUtil {
    AES_ECB_PKCS5("AES/ECB/PKCS5Padding"),
    AES_CBC_PKCS5("AES/CBC/PKCS5Padding");

    private final Cipher cipher;

    private CipherUtil(String transformation) {
        try {
            this.cipher = Cipher.getInstance(transformation);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("No such algorithm: " + transformation, e);
        }
        catch (NoSuchPaddingException e) {
            throw new IllegalArgumentException("No such padding: " + transformation, e);
        }
    }

    public byte[] encrypt(Key key, byte[] data) {
        return this.encrypt(key, data, null);
    }

    public byte[] encrypt(Key key, byte[] data, @Nullable AlgorithmParameterSpec params) {
        return this.encrypt(key, data, null, null);
    }

    public byte[] encrypt(Key key, byte[] data, @Nullable AlgorithmParameterSpec params, @Nullable SecureRandom random) {
        this.init(1, key, params, random);
        return this.doFinal(data);
    }

    public byte[] decrypt(Key key, byte[] data) {
        return this.decrypt(key, data, null);
    }

    public byte[] decrypt(Key key, byte[] data, @Nullable AlgorithmParameterSpec params) {
        return this.decrypt(key, data, params, null);
    }

    public byte[] decrypt(Key key, byte[] data, @Nullable AlgorithmParameterSpec params, @Nullable SecureRandom random) {
        this.init(2, key, params, random);
        return this.doFinal(data);
    }

    private void init(int mode, Key key, @Nullable AlgorithmParameterSpec params, @Nullable SecureRandom random) {
        try {
            if (params != null && random != null) {
                this.cipher.init(mode, key, params, random);
            } else if (params != null) {
                this.cipher.init(mode, key, params);
            } else if (random != null) {
                this.cipher.init(mode, key, random);
            } else {
                this.cipher.init(mode, key);
            }
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException("Invalid key: " + key, e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException("Invalid algorithm parameter: " + params, e);
        }
    }

    private byte[] doFinal(byte[] data) {
        try {
            return this.cipher.doFinal(data);
        }
        catch (IllegalBlockSizeException e) {
            throw new IllegalArgumentException("Illegal block size", e);
        }
        catch (BadPaddingException e) {
            throw new IllegalArgumentException("Bad padding", e);
        }
    }
}

