/*
 * Decompiled with CFR 0.152.
 */
package ezeyc.ealiplug.util;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayConfig;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayResponse;
import com.alipay.api.DefaultAlipayClient;
import com.alipay.api.request.AlipaySystemOauthTokenRequest;
import com.alipay.api.response.AlipaySystemOauthTokenResponse;
import ezeyc.ealiplug.config.AliMp;

public class AliUtil {
    private static AlipayClient client = null;

    private static AlipayClient getClient(AliMp mp) {
        client = new DefaultAlipayClient(mp.getGateWay().trim(), mp.getAppId().trim(), mp.getPrivateKey().trim(), mp.format, mp.charSet, mp.getPublicKey().trim(), mp.singType);
        return client;
    }

    private static AlipayClient getClientWithCert(AliMp mp) {
        AlipayConfig alipayConfig = new AlipayConfig();
        alipayConfig.setServerUrl(mp.getGateWay());
        alipayConfig.setAppId(mp.getAppId());
        alipayConfig.setPrivateKey(mp.getPrivateKey());
        alipayConfig.setAppCertPath(mp.getAppCertPath());
        alipayConfig.setAlipayPublicCertPath(mp.getPublicCertPath());
        alipayConfig.setRootCertPath(mp.getRootCertPath());
        alipayConfig.setFormat(mp.format);
        alipayConfig.setCharset(mp.charSet);
        alipayConfig.setSignType(mp.singType);
        try {
            return new DefaultAlipayClient(alipayConfig);
        }
        catch (AlipayApiException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static AlipaySystemOauthTokenResponse getUserByCode(AliMp mp, String authCode) {
        AlipaySystemOauthTokenRequest request = new AlipaySystemOauthTokenRequest();
        request.setGrantType("authorization_code");
        request.setCode(authCode.trim());
        return (AlipaySystemOauthTokenResponse)AliUtil.request((AlipayRequest)request, mp);
    }

    public static AlipayResponse request(AlipayRequest request, AliMp mp) {
        client = !"".equals(mp.getAppCertPath()) && mp.getAppCertPath() != null ? AliUtil.getClientWithCert(mp) : AliUtil.getClient(mp);
        try {
            if (!"".equals(mp.getAppCertPath()) && mp.getAppCertPath() != null) {
                return client.certificateExecute(request);
            }
            return client.execute(request);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

