/*
 * Decompiled with CFR 0.152.
 */
package com.erolc.mrouter.backstack;

import androidx.compose.runtime.MutableState;
import androidx.compose.runtime.internal.StabilityInferred;
import com.erolc.mrouter.backstack.entry.PageEntry;
import com.erolc.mrouter.backstack.entry.StackEntry;
import com.erolc.mrouter.model.LaunchMode;
import com.erolc.mrouter.model.Route;
import com.erolc.mrouter.model.SingleTop;
import com.erolc.mrouter.route.ClearTaskFlag;
import com.erolc.mrouter.route.ReplaceFlag;
import com.erolc.mrouter.route.RouteFlag;
import com.erolc.mrouter.route.StackFlag;
import com.erolc.mrouter.route.router.Router;
import com.erolc.mrouter.route.router.WindowRouter;
import com.erolc.mrouter.route.shareelement.ShareElementController;
import com.erolc.mrouter.route.transform.ExitState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0017\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u000bJ\b\u0010\u001b\u001a\u00020\u0019H\u0002J\u0006\u0010\u001e\u001a\u00020\u0017J\u0006\u0010\u001f\u001a\u00020\u0017J\u0017\u0010 \u001a\u00020\u00172\b\b\u0002\u0010!\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\"J\u0015\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%H\u0000\u00a2\u0006\u0002\b&J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)J\u0010\u0010*\u001a\u0004\u0018\u00010\u000b2\u0006\u0010+\u001a\u00020\u0003J\u001d\u0010,\u001a\u0004\u0018\u00010\u00192\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200\u00a2\u0006\u0002\u00101J\b\u00102\u001a\u0004\u0018\u00010\u000bJ\"\u00103\u001a\u00020\u00192\f\u00104\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u000b0\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0013\u00a8\u00066"}, d2={"Lcom/erolc/mrouter/backstack/BackStack;", "", "name", "", "<init>", "(Ljava/lang/String;)V", "getName", "()Ljava/lang/String;", "_backstack", "Lkotlinx/coroutines/flow/MutableStateFlow;", "", "Lcom/erolc/mrouter/backstack/entry/StackEntry;", "backStack", "Lkotlinx/coroutines/flow/StateFlow;", "getBackStack", "()Lkotlinx/coroutines/flow/StateFlow;", "threshold", "", "getThreshold", "()I", "setThreshold", "(I)V", "isPreBack", "", "addEntry", "", "entry", "clearTask", "size", "getSize", "isBottom", "isEmpty", "pop", "isDestroy", "pop$core", "execute", "flag", "Lcom/erolc/mrouter/route/RouteFlag;", "execute$core", "preBack", "parentRouter", "Lcom/erolc/mrouter/route/router/Router;", "findEntry", "address", "updateEntry", "route", "Lcom/erolc/mrouter/model/Route;", "launchMode", "Lcom/erolc/mrouter/model/LaunchMode;", "(Lcom/erolc/mrouter/model/Route;Lcom/erolc/mrouter/model/LaunchMode;)Lkotlin/Unit;", "findTopEntry", "updateEntries", "oldEntries", "newEntries", "core"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nBackStack.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackStack.kt\ncom/erolc/mrouter/backstack/BackStack\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,149:1\n1863#2,2:150\n1557#2:152\n1628#2,3:153\n808#2,11:156\n1863#2,2:167\n1863#2,2:169\n1#3:171\n*S KotlinDebug\n*F\n+ 1 BackStack.kt\ncom/erolc/mrouter/backstack/BackStack\n*L\n56#1:150,2\n88#1:152\n88#1:153,3\n96#1:156,11\n96#1:167,2\n115#1:169,2\n*E\n"})
public class BackStack {
    @NotNull
    private final String name;
    @NotNull
    private final MutableStateFlow<List<StackEntry>> _backstack;
    @NotNull
    private final StateFlow<List<StackEntry>> backStack;
    private int threshold;
    private boolean isPreBack;
    public static final int $stable = 8;

    public BackStack(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this._backstack = StateFlowKt.MutableStateFlow((Object)CollectionsKt.emptyList());
        this.backStack = FlowKt.asStateFlow(this._backstack);
        this.threshold = 1;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final StateFlow<List<StackEntry>> getBackStack() {
        return this.backStack;
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    public final void addEntry(@NotNull StackEntry entry) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        if (entry instanceof PageEntry) {
            Object it = object = CollectionsKt.takeLast((List)((List)this._backstack.getValue()), (int)2);
            boolean bl = false;
            if (it.size() == 2) {
                Object object2 = CollectionsKt.first((List)it);
                Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type com.erolc.mrouter.backstack.entry.PageEntry");
                ((PageEntry)object2).setFrozen$core(true);
            }
        }
        object = this._backstack;
        object.setValue((Object)CollectionsKt.plus((Collection)((Collection)object.getValue()), (Object)entry));
    }

    private final void clearTask() {
        Iterable $this$forEach$iv = CollectionsKt.take((Iterable)((Iterable)this._backstack.getValue()), (int)(((List)this._backstack.getValue()).size() - 1));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StackEntry it = (StackEntry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.erolc.mrouter.backstack.entry.PageEntry");
            ((PageEntry)it).destroy();
        }
        this._backstack.setValue((Object)CollectionsKt.listOf((Object)CollectionsKt.last((List)((List)this._backstack.getValue()))));
    }

    public final int getSize() {
        return ((List)this._backstack.getValue()).size();
    }

    public final boolean isBottom() {
        return this.getSize() == this.threshold;
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean pop$core(boolean isDestroy) {
        boolean bl;
        if (((List)this._backstack.getValue()).size() > this.threshold) {
            void $this$mapTo$iv$iv;
            Object object = this._backstack;
            Object object2 = CollectionsKt.last((List)((List)this._backstack.getValue()));
            StackEntry stackEntry = (StackEntry)object2;
            Iterable iterable = (Iterable)object.getValue();
            MutableStateFlow<List<StackEntry>> mutableStateFlow = object;
            boolean bl2 = false;
            if (this.isPreBack) {
                this.isPreBack = false;
            }
            if (isDestroy) {
                void $this$pop_u24lambda_u242;
                $this$pop_u24lambda_u242.destroy();
            }
            Unit unit = Unit.INSTANCE;
            mutableStateFlow.setValue((Object)CollectionsKt.minus((Iterable)iterable, (Object)object2));
            Object it = object = CollectionsKt.takeLast((List)((List)this._backstack.getValue()), (int)2);
            boolean bl3 = false;
            Iterable $this$map$iv = (Iterable)it;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                StackEntry stackEntry2 = (StackEntry)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl4 = false;
                PageEntry pageEntry = it2 instanceof PageEntry ? (PageEntry)it2 : null;
                if (pageEntry != null) {
                    pageEntry.setFrozen$core(false);
                }
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    public static /* synthetic */ boolean pop$core$default(BackStack backStack, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: pop");
        }
        if ((n & 1) != 0) {
            bl = true;
        }
        return backStack.pop$core(bl);
    }

    /*
     * WARNING - void declaration
     */
    public final void execute$core(@NotNull RouteFlag flag) {
        void $this$filterIsInstanceTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)flag, (String)"flag");
        Iterable $this$filterIsInstance$iv = flag.decode();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof StackFlag)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            StackFlag it = (StackFlag)element$iv;
            boolean bl = false;
            StackFlag stackFlag = it;
            if (stackFlag instanceof ClearTaskFlag || stackFlag instanceof ReplaceFlag) {
                this.clearTask();
                continue;
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    public final boolean preBack(@NotNull Router parentRouter) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)parentRouter, (String)"parentRouter");
        if (((List)this._backstack.getValue()).size() > this.threshold) {
            this.isPreBack = true;
            Object object = CollectionsKt.last((List)((List)this._backstack.getValue()));
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.erolc.mrouter.backstack.entry.PageEntry");
            PageEntry resumePage = (PageEntry)object;
            resumePage.getTransformState$core().setValue((Object)ExitState.INSTANCE);
            ShareElementController.INSTANCE.exitShare$core();
            bl = true;
        } else if (parentRouter instanceof WindowRouter) {
            Iterable $this$forEach$iv = (Iterable)this._backstack.getValue();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                StackEntry it = (StackEntry)element$iv;
                boolean bl2 = false;
                MutableState<Boolean> mutableState = it instanceof PageEntry ? (MutableState<Boolean>)it : null;
                if (mutableState == null || (mutableState = mutableState.isExit$core()) == null) continue;
                mutableState.setValue((Object)true);
            }
            bl = false;
        } else {
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final StackEntry findEntry(@NotNull String address) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            Iterable iterable = (Iterable)this._backstack.getValue();
            for (Object t : iterable) {
                StackEntry it = (StackEntry)t;
                boolean bl = false;
                if (!it.getAddress().match(address)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    @Nullable
    public final Unit updateEntry(@NotNull Route route, @NotNull LaunchMode launchMode) {
        Unit unit;
        Intrinsics.checkNotNullParameter((Object)route, (String)"route");
        Intrinsics.checkNotNullParameter((Object)launchMode, (String)"launchMode");
        if (Intrinsics.areEqual((Object)launchMode, (Object)SingleTop.INSTANCE)) {
            StackEntry stackEntry = this.findTopEntry();
            if (stackEntry != null) {
                StackEntry it = stackEntry;
                boolean bl = false;
                if (it.getAddress().match(route.getAddress())) {
                    MutableStateFlow<List<StackEntry>> mutableStateFlow = this._backstack;
                    mutableStateFlow.setValue((Object)CollectionsKt.minus((Iterable)((Iterable)mutableStateFlow.getValue()), (Object)it));
                    PageEntry newEntry = new PageEntry((PageEntry)it, route.getArgs());
                    MutableStateFlow<List<StackEntry>> mutableStateFlow2 = this._backstack;
                    mutableStateFlow2.setValue((Object)CollectionsKt.plus((Collection)((Collection)mutableStateFlow2.getValue()), (Object)newEntry));
                    unit = Unit.INSTANCE;
                } else {
                    unit = null;
                }
            } else {
                unit = null;
            }
        } else {
            unit = null;
        }
        return unit;
    }

    @Nullable
    public final StackEntry findTopEntry() {
        return (StackEntry)CollectionsKt.lastOrNull((List)((List)this._backstack.getValue()));
    }

    public final void updateEntries(@NotNull List<? extends StackEntry> oldEntries, @NotNull List<? extends StackEntry> newEntries) {
        Intrinsics.checkNotNullParameter(oldEntries, (String)"oldEntries");
        Intrinsics.checkNotNullParameter(newEntries, (String)"newEntries");
        MutableStateFlow<List<StackEntry>> mutableStateFlow = this._backstack;
        mutableStateFlow.setValue((Object)CollectionsKt.minus((Iterable)((Iterable)mutableStateFlow.getValue()), (Iterable)oldEntries));
        mutableStateFlow = this._backstack;
        mutableStateFlow.setValue((Object)CollectionsKt.plus((Collection)((Collection)mutableStateFlow.getValue()), (Iterable)newEntries));
    }
}

