/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.mlib.sdk.simple.evaluator;

import cn.eppdev.mlib.sdk.simple.commons.EppdevMlibException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.dmg.pmml.DataType;
import org.dmg.pmml.FieldName;
import org.dmg.pmml.OpType;
import org.jpmml.evaluator.Evaluator;
import org.jpmml.evaluator.EvaluatorUtil;
import org.jpmml.evaluator.FieldValue;
import org.jpmml.evaluator.InputField;
import org.jpmml.evaluator.LoadingModelEvaluatorBuilder;
import org.jpmml.evaluator.ModelEvaluator;
import org.jpmml.evaluator.visitors.DefaultVisitorBattery;
import org.jpmml.model.VisitorBattery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class EppdevMlibEvaluator {
    static Logger logger = LoggerFactory.getLogger(EppdevMlibEvaluator.class);
    private Evaluator evaluator = null;

    public static EppdevMlibEvaluator getInstance(String pmmlContent) throws EppdevMlibException {
        return new EppdevMlibEvaluator(pmmlContent);
    }

    private EppdevMlibEvaluator(String pmmlContent) throws EppdevMlibException {
        try {
            ModelEvaluator evaluator = new LoadingModelEvaluatorBuilder().setLocatable(false).setVisitors((VisitorBattery)new DefaultVisitorBattery()).load((InputStream)new ByteArrayInputStream(pmmlContent.getBytes())).build();
            this.evaluator = evaluator.verify();
        }
        catch (JAXBException | SAXException e) {
            logger.error("Error when parse pmml: {}", e);
            throw new EppdevMlibException("\u89e3\u6790pmml\u5931\u8d25");
        }
    }

    private Map<String, ?> evaluate(String json) throws EppdevMlibException {
        List inputFields = this.evaluator.getInputFields();
        LinkedHashMap<FieldName, FieldValue> arguments = new LinkedHashMap<FieldName, FieldValue>();
        try {
            JsonNode jsonNode = new ObjectMapper().readTree(json);
            for (InputField inputField : inputFields) {
                if (!jsonNode.has(inputField.getFieldName().getValue())) continue;
                JsonNode valueNode = jsonNode.get(inputField.getFieldName().getValue());
                arguments.put(inputField.getFieldName(), FieldValue.create((DataType)inputField.getDataType(), (OpType)inputField.getOpType(), (Object)valueNode.textValue()));
            }
        }
        catch (IOException e) {
            logger.error("json\u89e3\u6790\u9519\u8bef\uff1a {}", (Throwable)e);
            throw new EppdevMlibException("\u8ba1\u7b97\u9519\u8bef\uff1a" + e.getMessage());
        }
        Map results = this.evaluator.evaluate(arguments);
        return EvaluatorUtil.decodeAll((Map)results);
    }

    public String calc(String json) throws EppdevMlibException {
        try {
            return new ObjectMapper().writeValueAsString(this.evaluate(json));
        }
        catch (JsonProcessingException e) {
            logger.error("Error: {}", (Throwable)e);
            throw new EppdevMlibException("\u7ed3\u679c\u89e3\u6790\u9519\u8bef\uff1a" + e.getMessage());
        }
    }

    public String calc(String json, String fieldName) throws EppdevMlibException {
        Map<String, ?> map = this.evaluate(json);
        if (map.containsKey(fieldName)) {
            return map.get(fieldName).toString();
        }
        throw new EppdevMlibException("\u7ed3\u679c\u4e0d\u5b58\u5728");
    }
}

