/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.mlib.sdk.hive.udf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.Text;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EppdevMlibCalcUDF
extends UDF {
    static Logger logger = LoggerFactory.getLogger(EppdevMlibCalcUDF.class);
    static final String LOG_ERROR_STRING = "ERROR: {}";
    static final String CHARSET_UTF_8 = "UTF-8";
    static final String KEY_STATUS = "status";

    public Text evaluate(String basicUrl, String modelCode, String postJson) {
        return EppdevMlibCalcUDF.eppdevMlibCalc(basicUrl, modelCode, postJson);
    }

    public Text evaluate(String basicUrl, String modelCode, String postJson, String resultField) {
        return EppdevMlibCalcUDF.eppdevMlibCalc(basicUrl, modelCode, postJson, resultField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Text eppdevMlibCalc(String basicUrl, String modelCode, String postJson) {
        Text text = new Text();
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost post = new HttpPost(basicUrl + "/calc/" + modelCode);
        post.setHeader("Content-Type", "application/json;charset=UTF-8");
        post.setEntity((HttpEntity)new StringEntity(postJson, CHARSET_UTF_8));
        try {
            int status;
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET_UTF_8);
            JsonNode jsonNode = new ObjectMapper().readTree(result);
            if (jsonNode.has(KEY_STATUS) && (status = jsonNode.get(KEY_STATUS).intValue()) == 2000) {
                JsonNode dataNode = jsonNode.get("data");
                text.set(dataNode.toString());
            }
        }
        catch (IOException e) {
            logger.error("error: {}", (Throwable)e);
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                logger.error("error: {}", (Throwable)e);
            }
        }
        return text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Text eppdevMlibCalc(String basicUrl, String modelCode, String postJson, String resultField) {
        Text text = new Text();
        CloseableHttpClient client = HttpClients.createDefault();
        HttpPost post = new HttpPost(basicUrl + "/calc/" + modelCode);
        post.setHeader("Content-Type", "application/json;charset=UTF-8");
        post.setEntity((HttpEntity)new StringEntity(postJson, CHARSET_UTF_8));
        try {
            JsonNode dataNode;
            int status;
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            HttpEntity entity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)entity, (String)CHARSET_UTF_8);
            JsonNode jsonNode = new ObjectMapper().readTree(result);
            if (jsonNode.has(KEY_STATUS) && (status = jsonNode.get(KEY_STATUS).intValue()) == 2000 && (dataNode = jsonNode.get("data")).has(resultField)) {
                text.set(dataNode.get(resultField).asText());
            }
        }
        catch (IOException e) {
            logger.error("error: {}", (Throwable)e);
        }
        finally {
            try {
                client.close();
            }
            catch (IOException e) {
                logger.error("error: {}", (Throwable)e);
            }
        }
        return text;
    }
}

