/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.mlib.sdk.hive.udf;

import java.io.IOException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.io.Text;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EppdevMlibCalcUDF
extends UDF {
    static final String CHARSET_UTF_8 = "UTF-8";
    static final String KEY_WORD_STATUS = "status";
    static final String LOG_ERROR_STRING = "Error: {}";
    static Logger logger = LoggerFactory.getLogger(EppdevMlibCalcUDF.class);

    public Text evaluate(String basicUrl, String modelCode, String postJson) {
        return EppdevMlibCalcUDF.eppdevMlibCalc(basicUrl, modelCode, postJson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Text eppdevMlibCalc(String basicUrl, String modelCode, String postJson) {
        Text output = new Text();
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(basicUrl + "/calc/" + modelCode);
        method.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
        StringRequestEntity entity = new StringRequestEntity(postJson);
        method.setRequestEntity((RequestEntity)entity);
        try {
            int status;
            client.executeMethod((HttpMethod)method);
            String result = method.getResponseBodyAsString();
            JsonNode jsonNode = new ObjectMapper().readTree(result);
            if (jsonNode.has(KEY_WORD_STATUS) && (status = jsonNode.get(KEY_WORD_STATUS).getIntValue()) == 2000) {
                output.set(jsonNode.get("data").toString());
            }
        }
        catch (IOException e) {
            logger.error(LOG_ERROR_STRING, (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
        return output;
    }

    public Text evaluate(String basicUrl, String modelCode, String postJson, String resultField) {
        return EppdevMlibCalcUDF.eppdevMlibCalc(basicUrl, modelCode, postJson, resultField);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Text eppdevMlibCalc(String basicUrl, String modelCode, String postJson, String resultField) {
        Text output = new Text();
        HttpClient client = new HttpClient();
        PostMethod method = new PostMethod(basicUrl + "/calc/" + modelCode);
        method.setRequestHeader("Content-Type", "application/json;charset=UTF-8");
        StringRequestEntity requestEntity = new StringRequestEntity(postJson);
        method.setRequestEntity((RequestEntity)requestEntity);
        try {
            JsonNode dataNode;
            int status;
            client.executeMethod((HttpMethod)method);
            String result = method.getResponseBodyAsString();
            JsonNode jsonNode = new ObjectMapper().readTree(result);
            if (jsonNode.has(KEY_WORD_STATUS) && (status = jsonNode.get(KEY_WORD_STATUS).getIntValue()) == 2000 && (dataNode = jsonNode.get("data")).has(resultField)) {
                output.set(dataNode.get(resultField).asText());
            }
        }
        catch (IOException e) {
            logger.error(LOG_ERROR_STRING, (Throwable)e);
        }
        finally {
            method.releaseConnection();
        }
        return output;
    }
}

