/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.web;

import cn.eppdev.jee.conf.entity.EppdevIndex;
import cn.eppdev.jee.conf.service.IndexService;
import cn.eppdev.jee.conf.service.TableService;
import cn.eppdev.jee.share.entity.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="webIndexController")
@RequestMapping(value={"/web/conf/version/{versionId}/table/{tableId}/index"})
public class IndexController {
    static Logger logger = LoggerFactory.getLogger(IndexController.class);
    @Autowired
    IndexService indexService;
    @Autowired
    TableService tableService;

    @RequestMapping(value={"/add/to"})
    public String toAdd(@PathVariable(value="versionId") String versionId, @PathVariable(value="tableId") String tableId, Model model) {
        logger.debug("/web/conf/version/{}/table/{}/index/add/to", (Object)versionId, (Object)tableId);
        EppdevIndex index = new EppdevIndex();
        index.setTableId(tableId);
        model.addAttribute("index", (Object)index);
        model.addAttribute("tableId", (Object)tableId);
        model.addAttribute("versionId", (Object)versionId);
        model.addAttribute("table", this.tableService.get(tableId).getData());
        return "index/form";
    }

    @RequestMapping(value={"/add/do"})
    public String doAdd(@PathVariable(value="versionId") String versionId, @PathVariable(value="tableId") String tableId, EppdevIndex index, Model model, RedirectAttributes redirectAttributes) {
        RestResult result = this.indexService.add(index);
        logger.debug("/web/conf/version/{}/table/{}/index/add/do -> result:{}", new Object[]{versionId, tableId, result});
        if (RestResult.STATUS_SUCCESS == result.getStatus()) {
            redirectAttributes.addFlashAttribute("message", (Object)"\u6dfb\u52a0\u6210\u529f");
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)("\u6dfb\u52a0\u5931\u8d25:" + result.getMessage()));
        }
        return "redirect:/web/conf/version/" + versionId + "/table/view/" + tableId;
    }

    @RequestMapping(value={"/delete/{indexId}"})
    public String delete(@PathVariable(value="versionId") String versionId, @PathVariable(value="tableId") String tableId, @PathVariable(value="indexId") String indexId, RedirectAttributes redirectAttributes) {
        logger.debug("/web/conf/version/{}/table/{}/index/delete/{}", new Object[]{versionId, tableId, indexId});
        RestResult result = this.indexService.delete(indexId);
        if (RestResult.STATUS_SUCCESS == result.getStatus()) {
            redirectAttributes.addFlashAttribute("message", (Object)"\u6dfb\u52a0\u6210\u529f");
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)("\u6dfb\u52a0\u5931\u8d25:" + result.getMessage()));
        }
        return "redirect:/web/conf/version/" + versionId + "/table/view/" + tableId;
    }
}

