/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.cg.service;

import cn.eppdev.jee.cg.service.DataSchemaLoadService;
import cn.eppdev.jee.cg.service.FileGeneratorService;
import cn.eppdev.jee.share.entity.RestResult;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CgService {
    static Logger logger = LoggerFactory.getLogger(CgService.class);
    @Autowired
    FileGeneratorService fileGeneratorService;
    @Autowired
    DataSchemaLoadService dataSchemaLoadService;

    public RestResult<Map<String, String>> generateInitFileByFileName(String fileName) {
        Map map = new HashMap();
        try {
            map = this.fileGeneratorService.generateInitFileByFileName(fileName);
            return new RestResult(RestResult.STATUS_SUCCESS, "\u751f\u6210\u6210\u529f", map);
        }
        catch (Exception e) {
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), map);
        }
    }

    public RestResult<Map<String, String>> generateAllInitFile() {
        Map map = new HashMap();
        try {
            map = this.fileGeneratorService.generateAllInitFile();
            return new RestResult(RestResult.STATUS_SUCCESS, "\u751f\u6210\u6210\u529f", map);
        }
        catch (Exception e) {
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), map);
        }
    }

    public RestResult<Map<String, String>> generateInitFileByType(String type) {
        Map map = new HashMap();
        try {
            map = this.fileGeneratorService.generateInitFileByType(type);
            return new RestResult(RestResult.STATUS_SUCCESS, "\u751f\u6210\u6210\u529f", map);
        }
        catch (Exception e) {
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), map);
        }
    }

    public RestResult<Map<String, String>> generateVerionFileByType(String versionId, String type) {
        try {
            return new RestResult(RestResult.STATUS_SUCCESS, "\u751f\u6210\u6210\u529f", (Object)this.fileGeneratorService.generateVersionFileByType(versionId, type));
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), new HashMap());
        }
    }

    public RestResult<Map<String, String>> generateAllTableFile(String tableId) {
        try {
            return new RestResult(RestResult.STATUS_SUCCESS, "\u751f\u6210\u6210\u529f", (Object)this.fileGeneratorService.generateAllTableFile(tableId));
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), new HashMap());
        }
    }

    public RestResult<Map<String, String>> generateTableFileByType(String tableId, String type) {
        try {
            return new RestResult(RestResult.STATUS_SUCCESS, "\u751f\u6210\u6210\u529f", (Object)this.fileGeneratorService.generateTableFileByType(tableId, type));
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), new HashMap());
        }
    }

    public RestResult<String> readFromDb() {
        try {
            this.dataSchemaLoadService.updateTableInfo();
            return new RestResult(RestResult.STATUS_SUCCESS, "\u52a0\u8f7d\u6210\u529f", null);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), null);
        }
    }

    public RestResult<String> readFromDb(String tableName) {
        try {
            this.dataSchemaLoadService.updateTableInfo(tableName);
            return new RestResult(RestResult.STATUS_SUCCESS, "\u52a0\u8f7d\u6210\u529f", null);
        }
        catch (Exception e) {
            logger.error("Error: {}\n{}", (Object)e.getMessage(), (Object)e.getStackTrace());
            return new RestResult(RestResult.STATUS_FAILED, e.getMessage(), null);
        }
    }
}

