/*
 * Decompiled with CFR 0.152.
 */
package cn.eppdev.jee.conf.web;

import cn.eppdev.jee.conf.entity.EppdevTable;
import cn.eppdev.jee.conf.service.TableService;
import cn.eppdev.jee.share.entity.RestResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller(value="webTableController")
@RequestMapping(value={"/web/conf/version/{versionId}/table"})
public class TableController {
    static Logger logger = LoggerFactory.getLogger(TableController.class);
    @Autowired
    TableService tableService;

    @RequestMapping(value={"/view/{id}"})
    public String view(@PathVariable(value="id") String id, @PathVariable(value="versionId") String versionId, Model model, RedirectAttributes redirectAttributes) {
        RestResult result = this.tableService.get(id);
        logger.debug("/web/conf/table/view/{} -> result:{}", (Object)id, (Object)result);
        if (result.getStatus() != RestResult.STATUS_SUCCESS) {
            redirectAttributes.addFlashAttribute("message", (Object)("\u6570\u636e\u83b7\u53d6\u5931\u8d25: " + result.getMessage()));
            return "redirect:/web/conf/version/list";
        }
        model.addAttribute("table", result.getData());
        model.addAttribute("tableFileInfoList", (Object)this.tableService.getTableFileInfoList(id));
        return "table/view";
    }

    @RequestMapping(value={"/add/to"})
    public String toAdd(@PathVariable(value="versionId") String versionId, Model model) {
        EppdevTable eppdevTable = new EppdevTable();
        eppdevTable.setVersionId(versionId);
        model.addAttribute("table", (Object)eppdevTable);
        return "table/form";
    }

    @RequestMapping(value={"/add/do"})
    public String doAdd(@PathVariable(value="versionId") String versionId, EppdevTable eppdevTable, RedirectAttributes redirectAttributes) {
        RestResult result = this.tableService.add(eppdevTable);
        if (RestResult.STATUS_SUCCESS == result.getStatus()) {
            redirectAttributes.addFlashAttribute("message", (Object)"\u521b\u5efa\u6210\u529f");
            return "redirect:/web/conf/version/" + versionId + "/table/view/" + (String)result.getData();
        }
        redirectAttributes.addFlashAttribute("message", (Object)"\u521b\u5efa\u6210\u529f");
        return "redirect:/web/conf/version/view/" + eppdevTable.getVersionId();
    }

    @RequestMapping(value={"/update/{tableId}/to"})
    public String toUpdate(@PathVariable(value="tableId") String tableId, @PathVariable(value="versionId") String versionId, EppdevTable eppdevTable, Model model) {
        RestResult restResult = this.tableService.get(tableId);
        logger.debug("/web/conf/version/{}/table/update/{}/do -> restResult:{}", new Object[]{versionId, tableId, restResult});
        if (RestResult.STATUS_SUCCESS == restResult.getStatus()) {
            model.addAttribute("table", restResult.getData());
            return "table/form";
        }
        return "redirect:/web/conf/version/view/" + versionId;
    }

    @RequestMapping(value={"/update/{tableId}/do"})
    public String doUpdate(@PathVariable(value="versionId") String versionId, @PathVariable(value="tableId") String tableId, EppdevTable eppdevTable, RedirectAttributes redirectAttributes) {
        RestResult result = this.tableService.update(eppdevTable);
        logger.debug("/web/conf/version/{}/table/update/{}/do -> result:{}", new Object[]{versionId, tableId, result});
        if (RestResult.STATUS_SUCCESS == result.getStatus()) {
            redirectAttributes.addFlashAttribute("message", (Object)"\u4fee\u6539\u6210\u529f");
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)("\u4fee\u6539\u5931\u8d25\uff1a" + result.getMessage()));
        }
        return "redirect:/web/conf/version/" + versionId + "/table/view/" + tableId;
    }

    @RequestMapping(value={"/delete/{id}"})
    public String delete(@PathVariable(value="id") String id, @PathVariable(value="versionId") String versionId, RedirectAttributes redirectAttributes) {
        RestResult result = this.tableService.delete(id);
        if (RestResult.STATUS_SUCCESS == result.getStatus()) {
            redirectAttributes.addFlashAttribute("message", (Object)"\u5220\u9664\u6210\u529f");
        } else {
            redirectAttributes.addFlashAttribute("message", (Object)("\u5220\u9664\u5931\u8d25:" + result.getMessage()));
        }
        return "redirect:/web/conf/version/view/" + versionId;
    }

    @RequestMapping(value={"/{tableId}/preview/{type}"})
    public String preview(@PathVariable(value="versionId") String versionId, @PathVariable(value="tableId") String tableId, @PathVariable(value="type") String type, Model model, RedirectAttributes redirectAttributes) {
        logger.debug("/web/conf/version/{}/table/{}/preview/{}", new Object[]{versionId, tableId, type});
        RestResult result = this.tableService.preview(tableId, type);
        logger.debug("/web/conf/table/{}/preview/{} -> result:{}", new Object[]{tableId, type, result});
        if (RestResult.STATUS_SUCCESS == result.getStatus()) {
            model.addAttribute("content", result.getData());
            model.addAttribute("fileName", (Object)type);
            model.addAttribute("tableId", (Object)tableId);
            model.addAttribute("versionId", (Object)versionId);
            return "table/preview";
        }
        redirectAttributes.addFlashAttribute("message", (Object)("\u9884\u89c8\u51fa\u9519\uff1a" + result.getMessage()));
        return "redirect:/web/conf/version/" + versionId + "/table/view/" + tableId;
    }
}

